import { j as json } from "../../../../chunks/index.js";
import { createRequire } from "module";
import bcrypt from "bcrypt";
const require2 = createRequire(import.meta.url);
const { PrismaClient } = require2("@prisma/client");
const prisma = new PrismaClient();
const GET = async () => {
  const admins = await prisma.admin.findMany();
  return json(admins);
};
const POST = async ({ request }) => {
  const { username, password, phoneNumber, email, role, privileges } = await request.json();
  const hashedPassword = await bcrypt.hash(password, 10);
  const newAdmin = await prisma.admin.create({
    data: {
      username,
      password: hashedPassword,
      // Store the hashed password
      phoneNumber,
      email,
      role,
      privileges
    }
  });
  return json(newAdmin, { status: 201 });
};
export {
  GET,
  POST
};
