import { j as json } from "../../../../chunks/index.js";
import { createRequire } from "module";
const require2 = createRequire(import.meta.url);
const { PrismaClient } = require2("@prisma/client");
const prisma = new PrismaClient();
const GET = async () => {
  try {
    const existingResponses = await prisma.response.findMany();
    return json(existingResponses);
  } catch (error) {
    console.error("Error fetching existing responses:", error);
    return json({ message: "Error fetching existing responses", error: error.message }, { status: 500 });
  }
};
const POST = async ({ request }) => {
  const { brandId, clientId, questionId, value, createdAt } = await request.json();
  try {
    const clientExists = await prisma.client.findUnique({ where: { id: clientId } });
    const brandExists = await prisma.brand.findUnique({ where: { id: brandId } });
    const questionExists = await prisma.question.findUnique({ where: { id: questionId } });
    const dateExists = await prisma.question.findUnique({ where: { id: createdAt } });
    if (!clientExists || !brandExists || !questionExists || dateExists) {
      return json({ error: "One or more foreign keys do not exist" }, { status: 400 });
    }
    let response = await prisma.response.findFirst({
      where: {
        clientId,
        questionId,
        brandId,
        createdAt
      }
    });
    if (response) {
      response = await prisma.response.update({
        where: { id: response.id },
        data: {
          value
        }
      });
    } else {
      response = await prisma.response.create({
        data: {
          questionId,
          clientId,
          brandId,
          value,
          createdAt
        }
      });
    }
    return json(response, { status: 201 });
  } catch (error) {
    console.error("Error saving response:", error);
    return json({ error: "Failed to save response" }, { status: 500 });
  }
};
export {
  GET,
  POST
};
