import { r as rest_props, m as element, s as slot, d as spread_attributes, f as bind_props, p as pop, h as sanitize_props, b as push, c as copy_payload, a as assign_payload, i as ensure_array_like, k as stringify, j as attr, e as escape_html } from "../../../../chunks/hooks.server.js";
import "../../../../chunks/index2.js";
import { I as Input, L as Label } from "../../../../chunks/label.js";
import { b as badgeVariants } from "../../../../chunks/index3.js";
import "clsx";
import { F as Fa } from "../../../../chunks/fa.js";
/* empty css                                                              */
import { faFileExcel, faFilter, faSearch, faCar, faSort, faBuilding, faWrench } from "@fortawesome/free-solid-svg-icons";
import "../../../../chunks/index.js";
import { c as cn, B as Button } from "../../../../chunks/button.js";
import { f as fallback } from "../../../../chunks/utils.js";
function Badge($$payload, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, ["class", "href", "variant"]);
  push();
  let className = fallback($$props["class"], void 0);
  let href = fallback($$props["href"], void 0);
  let variant = fallback($$props["variant"], "default");
  element(
    $$payload,
    href ? "a" : "span",
    () => {
      $$payload.out += `${spread_attributes({
        href,
        class: cn(badgeVariants({ variant, className })),
        ...$$restProps
      })}`;
    },
    () => {
      $$payload.out += `<!---->`;
      slot($$payload, $$props, "default", {});
      $$payload.out += `<!---->`;
    }
  );
  bind_props($$props, { class: className, href, variant });
  pop();
}
function _page($$payload, $$props) {
  push();
  let formIdMapping = {};
  let questions = [];
  let selectedDepartment;
  let responses = [];
  let clients = [];
  let brands = [];
  let searchQuery = "";
  let selectedBrands = [];
  let selectedRatings = [];
  const ratingLabels = {
    1: {
      text: "Shumë keq",
      color: "bg-red-500",
      hoverColor: "hover:bg-red-600",
      borderColor: "hover:border-red-500"
    },
    2: {
      text: "Keq",
      color: "bg-orange-500",
      hoverColor: "hover:bg-orange-600",
      borderColor: "hover:border-orange-500"
    },
    3: {
      text: "Mirë",
      color: "bg-yellow-500",
      hoverColor: "hover:bg-yellow-600",
      borderColor: "hover:border-yellow-500"
    },
    4: {
      text: "Shumë mirë",
      color: "bg-lime-500",
      hoverColor: "hover:bg-lime-600",
      borderColor: "hover:border-lime-500"
    },
    5: {
      text: "Shkëlqyeshëm",
      color: "bg-green-500",
      hoverColor: "hover:bg-green-600",
      borderColor: "hover:border-green-500"
    }
  };
  function formatDate(dateStr) {
    const date = new Date(dateStr);
    const day = String(date.getDate()).padStart(2, "0");
    const months = [
      "Janar",
      "Shkurt",
      "Mars",
      "Prill",
      "Maj",
      "Qershor",
      "Korrik",
      "Gusht",
      "Shtator",
      "Tetor",
      "Nëntor",
      "Dhjetor"
    ];
    const month = months[date.getMonth()];
    const year = date.getFullYear();
    const hours = String(date.getHours()).padStart(2, "0");
    const minutes = String(date.getMinutes()).padStart(2, "0");
    return `${day} ${month} ${year}, ${hours}:${minutes}`;
  }
  responses.filter((response) => {
    console.groupCollapsed("Filtering response");
    console.log("response:", response);
    if (searchQuery) {
      const query = searchQuery.toLowerCase().split(/\s+/);
      const searchMatch = (response2) => query.every((q) => [
        clients.find((c) => c.id === response2.clientId)?.username.toLowerCase(),
        questions.find((q2) => q2.id === response2.questionId)?.formId === formIdMapping[selectedDepartment] ? selectedDepartment : "",
        brands.find((b) => b.id === response2.brandId)?.name.toLowerCase(),
        formatDate(new Date(response2.createdAt)).toLowerCase()
      ].some((value) => value.includes(q)));
      console.log("search query:", query);
      console.log("search match:", searchMatch(response));
      if (!searchMatch(response)) {
        console.log("filtered out due to search");
        console.groupEnd();
        return false;
      }
    }
    if (selectedBrands.length > 0 && !selectedBrands.some((b) => b.id === response.brandId)) {
      console.log("filtered out due to brand");
      console.groupEnd();
      return false;
    }
    if (selectedRatings.length > 0 && !selectedRatings.some((r) => r === parseInt(response.value))) {
      console.log("filtered out due to rating");
      console.groupEnd();
      return false;
    }
    console.groupEnd();
    return true;
  });
  let $$settled = true;
  let $$inner_payload;
  function $$render_inner($$payload2) {
    const each_array = ensure_array_like(brands);
    const each_array_1 = ensure_array_like([1, 2, 3, 4, 5]);
    $$payload2.out += `<div class="h-[calc(100vh-4.8rem)] flex flex-col bg-[#111111] overflow-hidden"><div class="flex-none p-4"><div class="flex items-center justify-between"><h1 class="text-2xl font-bold text-white">Tabela e Feedback-ut</h1> <div class="flex gap-2">`;
    Button($$payload2, {
      variant: "default",
      class: "border-[#ff6b00] bg-[#ff6b00] text-black hover:bg-[#ff6b00a2] hover:text-white",
      children: ($$payload3) => {
        Fa($$payload3, { icon: faFileExcel, class: "mr-2 h-4 w-4" });
        $$payload3.out += `<!----> Export`;
      },
      $$slots: { default: true }
    });
    $$payload2.out += `<!----></div></div></div> <div class="flex-1 min-h-0 flex"><div class="w-64 flex-none h-full pr-4 overflow-y-auto"><div class="p-6 space-y-6"><div class="flex items-center justify-between"><span class="text-lg font-semibold text-white flex items-center gap-2">`;
    Fa($$payload2, { icon: faFilter, class: "text-[#ff6b00]" });
    $$payload2.out += `<!----> Filtrat</span> `;
    {
      $$payload2.out += "<!--[-->";
      Button($$payload2, {
        variant: "ghost",
        size: "sm",
        class: "text-[#ff6b00] hover:text-[#ff6b00]/80",
        children: ($$payload3) => {
          $$payload3.out += `<!---->Pastro Filtrat`;
        },
        $$slots: { default: true }
      });
    }
    $$payload2.out += `<!--]--></div> <div class="relative">`;
    Fa($$payload2, {
      icon: faSearch,
      class: "absolute left-3 top-1/2 -translate-y-1/2 text-gray-400"
    });
    $$payload2.out += `<!----> `;
    Input($$payload2, {
      type: "text",
      placeholder: "Search...",
      class: "pl-10 bg-[#111111] border-white/20 focus:border-[#ff6b00] text-white placeholder-gray-500",
      get value() {
        return searchQuery;
      },
      set value($$value) {
        searchQuery = $$value;
        $$settled = false;
      }
    });
    $$payload2.out += `<!----></div> <div class="space-y-2">`;
    Label($$payload2, {
      class: "text-sm font-medium flex items-center gap-2 text-gray-300",
      children: ($$payload3) => {
        Fa($$payload3, { icon: faCar, class: "text-[#ff6b00]" });
        $$payload3.out += `<!----> Marka`;
      },
      $$slots: { default: true }
    });
    $$payload2.out += `<!----> <div class="flex flex-wrap gap-2"><!--[-->`;
    for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
      let brand = each_array[$$index];
      $$payload2.out += `<button class="group">`;
      Badge($$payload2, {
        variant: selectedBrands.includes(brand) ? "default" : "outline",
        class: `${stringify(selectedBrands.includes(brand) ? "bg-[#ff6b00] hover:bg-[#ff6b00]/90" : "")} border border-white/20 hover:border-[#ff6b00] hover:text-white rounded-lg p-3 flex-col items-center gap-1`,
        children: ($$payload3) => {
          $$payload3.out += `<img${attr("src", brand.imageUrl)}${attr("alt", brand.name)} class="w-16 h-16 rounded-full invert"> <span class="font-medium text-white">${escape_html(brand.name)}</span>`;
        },
        $$slots: { default: true }
      });
      $$payload2.out += `<!----></button>`;
    }
    $$payload2.out += `<!--]--></div></div>  <div class="space-y-4">`;
    Label($$payload2, {
      class: "text-lg font-semibold text-white flex items-center gap-2",
      children: ($$payload3) => {
        Fa($$payload3, { icon: faSort, class: "text-[#ff6b00]" });
        $$payload3.out += `<!----> Pergjigja`;
      },
      $$slots: { default: true }
    });
    $$payload2.out += `<!----> <div class="flex flex-wrap gap-2"><!--[-->`;
    for (let $$index_1 = 0, $$length = each_array_1.length; $$index_1 < $$length; $$index_1++) {
      let rating = each_array_1[$$index_1];
      $$payload2.out += `<button>`;
      Badge($$payload2, {
        variant: selectedRatings.includes(rating) ? "default" : "outline",
        class: `${stringify(selectedRatings.includes(rating) ? `${ratingLabels[rating].color} text-white ${ratingLabels[rating].hoverColor}` : `border-2 border-white/20 ${ratingLabels[rating].borderColor} hover:text-white`)} rounded-lg px-3 py-2 transition-colors`,
        children: ($$payload3) => {
          $$payload3.out += `<!---->${escape_html(ratingLabels[rating].text)}`;
        },
        $$slots: { default: true }
      });
      $$payload2.out += `<!----></button>`;
    }
    $$payload2.out += `<!--]--></div></div></div></div> <div class="flex-1 flex flex-col min-w-0 bg-[#1a1a1a] rounded-lg border border-white/10"><div class="flex-none p-4 border-b border-white/10"><div class="flex items-center justify-between"><div class="flex items-center gap-4">`;
    Label($$payload2, {
      class: "text-sm font-medium flex items-center gap-2 text-gray-300",
      children: ($$payload3) => {
        Fa($$payload3, { icon: faBuilding, class: "text-[#ff6b00]" });
        $$payload3.out += `<!----> Departamenti`;
      },
      $$slots: { default: true }
    });
    $$payload2.out += `<!----> <div class="flex flex-wrap gap-2">`;
    Button($$payload2, {
      variant: "outline",
      class: "border border-white/20 hover:border-[#ff6b00] hover:text-white",
      children: ($$payload3) => {
        Fa($$payload3, { icon: faBuilding, class: "mr-2" });
        $$payload3.out += `<!----> Te gjitha`;
      },
      $$slots: { default: true }
    });
    $$payload2.out += `<!----> `;
    Button($$payload2, {
      variant: "outline",
      class: "border border-white/20 hover:border-[#ff6b00] hover:text-white",
      children: ($$payload3) => {
        Fa($$payload3, { icon: faCar, class: "mr-2" });
        $$payload3.out += `<!----> Shitje`;
      },
      $$slots: { default: true }
    });
    $$payload2.out += `<!----> `;
    Button($$payload2, {
      variant: "outline",
      class: "border border-white/20 hover:border-[#ff6b00] hover:text-white",
      children: ($$payload3) => {
        Fa($$payload3, { icon: faWrench, class: "mr-2" });
        $$payload3.out += `<!----> Servis`;
      },
      $$slots: { default: true }
    });
    $$payload2.out += `<!----></div></div></div></div> <div class="flex-1 min-h-0 relative"><div class="absolute inset-0 overflow-auto svelte-1lucu9p">`;
    {
      $$payload2.out += "<!--[-->";
      $$payload2.out += `<div class="flex h-full w-full items-center justify-center"><div class="text-center"><p class="text-gray-300 text-2xl">Zgjidhni departamentin.</p></div></div>`;
    }
    $$payload2.out += `<!--]--></div></div></div></div></div>`;
  }
  do {
    $$settled = true;
    $$inner_payload = copy_payload($$payload);
    $$render_inner($$inner_payload);
  } while (!$$settled);
  assign_payload($$payload, $$inner_payload);
  pop();
}
export {
  _page as default
};
