import { l as store_get, i as ensure_array_like, e as escape_html, j as attr, k as stringify, u as unsubscribe_stores, p as pop, b as push } from "../../../../chunks/hooks.server.js";
import "clsx";
import "../../../../chunks/index2.js";
import { F as Fa } from "../../../../chunks/fa.js";
/* empty css                                                              */
import { faArrowLeft, faCoins, faClock, faRotateRight } from "@fortawesome/free-solid-svg-icons";
import "canvas-confetti";
/* empty css                                                                 */
import "../../../../chunks/score.js";
import { f as feedbackStore } from "../../../../chunks/feedbackStore.js";
import { B as Button } from "../../../../chunks/button.js";
function _page($$payload, $$props) {
  push();
  var $$store_subs;
  let cards = [];
  let timer = 0;
  let scoreIndicators = [];
  let currentScore = 0;
  let currentRound = store_get($$store_subs ??= {}, "$feedbackStore", feedbackStore).currentRound;
  if (store_get($$store_subs ??= {}, "$feedbackStore", feedbackStore).currentRound !== currentRound) {
    currentRound = store_get($$store_subs ??= {}, "$feedbackStore", feedbackStore).currentRound;
    console.log("🔄 Round updated from store:", currentRound);
  }
  const each_array = ensure_array_like(scoreIndicators);
  const each_array_1 = ensure_array_like(cards);
  $$payload.out += `<div class="h-full flex flex-col"><header class="flex justify-between items-center h-14 px-6 mb-4 bg-gradient-to-r bg-orange-600/10 backdrop-blur-sm border-b border-orange-500/20 rounded-lg"><div class="flex items-center gap-6"><a href="/" class="flex items-center justify-center w-8 h-8 rounded-full hover:bg-orange-500/20 transition-colors">`;
  Fa($$payload, { icon: faArrowLeft, class: "text-lg" });
  $$payload.out += `<!----></a> <h1 class="text-xl font-bold tracking-tight">Pick the Pairs</h1></div> <div class="flex items-center gap-6"><div class="flex items-center gap-2 bg-orange-500/10 px-4 py-2 rounded-lg">`;
  Fa($$payload, { icon: faCoins, class: "text-orange-400" });
  $$payload.out += `<!----> <span class="font-medium">${escape_html(currentScore)}</span></div> <div class="flex items-center gap-2 bg-orange-500/10 px-4 py-2 rounded-lg">`;
  Fa($$payload, { icon: faClock, class: "text-orange-400" });
  $$payload.out += `<!----> <span class="font-medium">${escape_html(Math.floor(timer / 60))}:${escape_html((timer % 60).toString().padStart(2, "0"))}</span></div> <div class="w-px h-8 bg-orange-500/20"></div> `;
  Button($$payload, {
    variant: "ghost",
    size: "icon",
    class: "w-8 h-8 rounded-full hover:bg-orange-500/20",
    children: ($$payload2) => {
      Fa($$payload2, { icon: faRotateRight });
    },
    $$slots: { default: true }
  });
  $$payload.out += `<!----></div></header> <main class="flex-1 p-2 flex items-center justify-center min-h-0"><div class="relative w-full max-w-4xl mx-auto"><!--[-->`;
  for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
    let indicator = each_array[$$index];
    $$payload.out += `<div class="absolute pointer-events-none z-50"${attr("style", ` left: ${stringify(indicator.x)}px; top: ${stringify(indicator.y)}px; transform: translate(-50%, -50%) scale(${stringify(indicator.scale)}); opacity: ${stringify(indicator.opacity)}; `)}>`;
    if (indicator.text) {
      $$payload.out += "<!--[-->";
      $$payload.out += `<div${attr("class", `text-2xl font-bold ${stringify(indicator.color)} drop-shadow-lg svelte-ojigp7`)}>${escape_html(indicator.text)}</div>`;
    } else {
      $$payload.out += "<!--[!-->";
      $$payload.out += `<div class="text-3xl font-bold text-red-400 drop-shadow-lg">✕</div>`;
    }
    $$payload.out += `<!--]--></div>`;
  }
  $$payload.out += `<!--]--> <div class="grid grid-cols-4 gap-2 w-full aspect-[4/3]"><!--[-->`;
  for (let index = 0, $$length = each_array_1.length; index < $$length; index++) {
    let card = each_array_1[index];
    $$payload.out += `<button${attr("class", `relative w-full h-full ${stringify([""].filter(Boolean).join(" "))}`)}><div${attr("class", `absolute inset-0 w-full h-full transition-transform duration-500 transform-style-3d ${stringify(card.isFlipped || card.isMatched ? "rotate-y-180" : "")} svelte-ojigp7`)}><div class="absolute inset-0 w-full h-full backface-hidden bg-zinc-900 rounded-lg border bg-black/65 dark:bg-black/50 svelte-ojigp7"><img src="/images/logos/porsche-logo.png" alt="Card back" class="w-full h-full object-contain p-6"></div> <div${attr("class", `absolute inset-0 w-full h-full backface-hidden rotate-y-180 bg-white rounded-lg border border-zinc-200 dark:border-zinc-800 overflow-hidden ${stringify(card.isMatched ? "opacity-60" : "")} svelte-ojigp7`)}><div class="w-full h-full p-2"><img${attr("src", card.image)} alt="Car" class="w-full h-full object-contain bg-white rounded-lg"></div></div></div></button>`;
  }
  $$payload.out += `<!--]--></div></div></main></div> `;
  {
    $$payload.out += "<!--[!-->";
  }
  $$payload.out += `<!--]--> `;
  {
    $$payload.out += "<!--[!-->";
  }
  $$payload.out += `<!--]-->`;
  if ($$store_subs) unsubscribe_stores($$store_subs);
  pop();
}
export {
  _page as default
};
