import { j as json } from "../../../../chunks/index.js";
import fs from "fs";
import path from "path";
const POST = async ({ request }) => {
  const url = new URL(request.url);
  const filePath = url.searchParams.get("path");
  if (!filePath) {
    return json({ error: "File path is required" }, { status: 400 });
  }
  const data = await request.formData();
  const file = data.get("image");
  if (!file) {
    return json({ error: "No file uploaded" }, { status: 400 });
  }
  const fileBuffer = Buffer.from(await file.arrayBuffer());
  const fullPath = path.join(process.cwd(), filePath);
  try {
    fs.mkdirSync(path.dirname(fullPath), { recursive: true });
    fs.writeFileSync(fullPath, fileBuffer);
    return json({ message: "File uploaded successfully", url: filePath.replace("static", "") }, { status: 200 });
  } catch (error) {
    console.error("Error uploading file:", error);
    return json({ error: "Failed to upload file" }, { status: 500 });
  }
};
export {
  POST
};
