import { l as store_get, i as ensure_array_like, k as stringify, e as escape_html, u as unsubscribe_stores, p as pop, b as push, s as slot } from "../../../chunks/hooks.server.js";
import { p as page } from "../../../chunks/stores.js";
import "../../../chunks/index2.js";
import "../../../chunks/client.js";
import { F as Fa } from "../../../chunks/fa.js";
/* empty css                                                           */
import { faToolbox, faSignOutAlt } from "@fortawesome/free-solid-svg-icons";
import { B as Button } from "../../../chunks/button.js";
function html(value) {
  var html2 = String(value ?? "");
  var open = "<!---->";
  return open + html2 + "<!---->";
}
function Admin_navbar($$payload, $$props) {
  push();
  var $$store_subs;
  let isLoginPage;
  const navItems = [
    {
      title: "Editor Pyetesori",
      href: "/admin/form-editor",
      icon: `<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z" />`
    },
    {
      title: "Tabela e Feedback-ut",
      href: "/admin/feedback",
      icon: `<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z" />`
    },
    {
      title: "Menaxhim Admin",
      href: "/admin/users",
      icon: `<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />`
    }
  ];
  isLoginPage = store_get($$store_subs ??= {}, "$page", page).url.pathname === "/admin/login";
  if (!isLoginPage) {
    $$payload.out += "<!--[-->";
    const each_array = ensure_array_like(navItems);
    $$payload.out += `<header class="border-b border-white/20 bg-[#1a1a1a] backdrop-blur supports-[backdrop-filter]:bg-background/60 sticky top-0 z-50 w-full"><div class="container mx-auto px-4"><div class="flex h-12 items-center justify-between"><a href="/admin"><div class="flex items-center space-x-2">`;
    Fa($$payload, { icon: faToolbox, class: "text-2xl" });
    $$payload.out += `<!----> <span class="text-xl font-bold">Panel Administratori</span></div></a> <nav class="flex items-center space-x-1"><!--[-->`;
    for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
      let item = each_array[$$index];
      Button($$payload, {
        variant: "ghost",
        class: `flex items-center h-12 px-4 gap-2 rounded-none relative hover:bg-[#ff6b00]/30 ${stringify(store_get($$store_subs ??= {}, "$page", page).url.pathname === item.href ? "bg-[#ff6b00]/20 text-[#ff6b00] hover:bg-[#ff6b00]/30" : "")}`,
        children: ($$payload2) => {
          $$payload2.out += `<svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">${html(item.icon)}</svg> <span>${escape_html(item.title)}</span> `;
          if (store_get($$store_subs ??= {}, "$page", page).url.pathname === item.href) {
            $$payload2.out += "<!--[-->";
            $$payload2.out += `<div class="absolute bottom-0 left-0 w-full h-1 bg-[#ff6b00]"></div>`;
          } else {
            $$payload2.out += "<!--[!-->";
          }
          $$payload2.out += `<!--]-->`;
        },
        $$slots: { default: true }
      });
    }
    $$payload.out += `<!--]--></nav> <div class="flex items-center space-x-4">`;
    Button($$payload, {
      variant: "destructive",
      class: "border-red-800 hover:bg-red-600 gap-2",
      children: ($$payload2) => {
        Fa($$payload2, { icon: faSignOutAlt });
        $$payload2.out += `<!----> Dil`;
      },
      $$slots: { default: true }
    });
    $$payload.out += `<!----></div></div></div></header>`;
  } else {
    $$payload.out += "<!--[!-->";
  }
  $$payload.out += `<!--]-->`;
  if ($$store_subs) unsubscribe_stores($$store_subs);
  pop();
}
function _layout($$payload, $$props) {
  $$payload.out += `<div class="min-h-screen bg-[#111111] flex flex-col">`;
  Admin_navbar($$payload);
  $$payload.out += `<!----> <main class="flex-1"><!---->`;
  slot($$payload, $$props, "default", {});
  $$payload.out += `<!----></main></div>`;
}
export {
  _layout as default
};
