import { l as store_get, j as attr, k as stringify, i as ensure_array_like, e as escape_html, u as unsubscribe_stores, p as pop, b as push, c as copy_payload, a as assign_payload } from "../../../../chunks/hooks.server.js";
import "clsx";
import { o as onDestroy } from "../../../../chunks/index2.js";
import { F as Fa } from "../../../../chunks/fa.js";
/* empty css                                                              */
import { faStar, faCar, faWrench, faArrowLeft, faGamepad, faClock, faStairs, faGear, faRotateRight } from "@fortawesome/free-solid-svg-icons";
/* empty css                                                                 */
import { s as sessionManager } from "../../../../chunks/sessionStore.js";
import { faStar as faStar$1 } from "@fortawesome/free-regular-svg-icons";
import { f as feedbackStore } from "../../../../chunks/feedbackStore.js";
import { T as Textarea } from "../../../../chunks/textarea.js";
import "canvas-confetti";
import { B as Button } from "../../../../chunks/button.js";
import "../../../../chunks/score.js";
function GameFeedbackModal($$payload, $$props) {
  push();
  var $$store_subs;
  let questions = [];
  let answers = {};
  let progress = 0;
  let selectedDepartment = localStorage.getItem("selectedDepartment");
  let selectedBrand = localStorage.getItem("selectedBrand");
  let brands = [];
  let currentQuestionPair = [];
  let isLoading = true;
  let feedbackShownToday = false;
  let thankYouMessageVisible = false;
  let currentRound = store_get($$store_subs ??= {}, "$feedbackStore", feedbackStore).currentRound;
  let isFirstOddRoundToday = false;
  let questionsShownForCurrentRound = false;
  let isVisible = false;
  sessionManager.subscribe((value) => {
    value.user;
  });
  function isToday(date) {
    const today = /* @__PURE__ */ new Date();
    return date.getDate() === today.getDate() && date.getMonth() === today.getMonth() && date.getFullYear() === today.getFullYear();
  }
  function checkFirstOddRoundStatus() {
    const lastSetupDate = localStorage.getItem("feedbackSetupDate");
    if (!lastSetupDate) {
      isFirstOddRoundToday = true;
      return;
    }
    const setupDate = new Date(lastSetupDate);
    isFirstOddRoundToday = !isToday(setupDate);
  }
  {
    currentRound = store_get($$store_subs ??= {}, "$feedbackStore", feedbackStore).currentRound;
    if (currentRound % 2 === 1 && !feedbackShownToday) {
      checkFirstOddRoundStatus();
      questionsShownForCurrentRound = false;
    }
  }
  {
    const shouldShow = currentRound % 2 === 1 && !feedbackShownToday && !isLoading && !questionsShownForCurrentRound;
    if (shouldShow !== isVisible) {
      isVisible = shouldShow;
      console.log("📝 Modal visibility updated:", {
        isVisible,
        currentRound,
        feedbackShownToday,
        isLoading,
        questionsShownForCurrentRound
      });
    }
  }
  {
    const totalItems = questions.length + 2;
    const answeredCount = Object.keys(answers).length;
    progress = answeredCount / totalItems * 100;
  }
  if (isVisible) {
    $$payload.out += "<!--[-->";
    $$payload.out += `<div class="fixed inset-0 z-40 overflow-hidden"><div class="absolute inset-0 bg-black/50 backdrop-blur-sm"></div> <div class="absolute inset-0 overflow-y-auto"><div class="flex min-h-full items-center justify-center p-4"><div class="relative w-full max-w-xl rounded-xl bg-white dark:bg-zinc-900 shadow-lg"><div class="p-6"><div class="space-y-6"><div><h2 class="text-2xl font-bold text-center">Na ndihmoni të përmirësohemi</h2> <p class="text-center text-zinc-600 dark:text-zinc-400 mt-2">Ju lutemi të jepni përgjigjet tuaja në këtë form.</p> <div class="w-full bg-gray-300 dark:bg-zinc-800 rounded-full h-2.5 mt-4"><div class="bg-primary h-2.5 rounded-full transition-all duration-500"${attr("style", `width: ${stringify(progress)}%`)}></div></div></div> <div class="space-y-6">`;
    if (isFirstOddRoundToday) {
      $$payload.out += "<!--[-->";
      const each_array = ensure_array_like(brands);
      $$payload.out += `<div class="space-y-4"><h3 class="text-lg font-semibold text-center">Cfarë shërbimi kryet?</h3> <div class="grid grid-cols-2 gap-4"><button type="button"${attr("class", `flex flex-col items-center gap-3 p-4 rounded-xl border-2 transition-colors ${stringify(selectedDepartment === "sales" ? "border-orange-500 bg-orange-500/10" : "border-zinc-800 hover:border-orange-500/50")}`)}>`;
      Fa($$payload, { icon: faCar, class: "text-3xl" });
      $$payload.out += `<!----> <span class="font-medium">Shitje</span></button> <button type="button"${attr("class", `flex flex-col items-center gap-3 p-4 rounded-xl border-2 transition-colors ${stringify(selectedDepartment === "service" ? "border-orange-500 bg-orange-500/10" : "border-zinc-800 hover:border-orange-500/50")}`)}>`;
      Fa($$payload, { icon: faWrench, class: "text-3xl" });
      $$payload.out += `<!----> <span class="font-medium">Servis</span></button></div></div> <div class="space-y-4"><h3 class="text-lg font-semibold text-center">Zgjidhni markën tuaj</h3> <div class="grid grid-cols-2 gap-4"><!--[-->`;
      for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
        let brand = each_array[$$index];
        $$payload.out += `<button type="button"${attr("class", `flex flex-col items-center p-4 rounded-xl border-2 transition-colors ${stringify(selectedBrand === brand.id ? "border-orange-500 bg-orange-500/10" : "border-zinc-800 hover:border-orange-500/50")}`)}><img${attr("src", brand.imageUrl)}${attr("alt", brand.name)} class="w-20 h-20 dark:invert"> <span class="font-medium">${escape_html(brand.name)}</span></button>`;
      }
      $$payload.out += `<!--]--></div></div>`;
    } else {
      $$payload.out += "<!--[!-->";
      if (currentQuestionPair.length === 0 && thankYouMessageVisible) {
        $$payload.out += "<!--[-->";
        $$payload.out += `<div class="text-center space-y-2"><p class="text-xl font-bold">Faleminderit për përgjigjet tuaja!</p> <p class="text-zinc-600 dark:text-zinc-400">Feedback-u juaj na ndihmon të përmirësohemi.</p></div>`;
      } else {
        $$payload.out += "<!--[!-->";
        if (currentQuestionPair.length > 0) {
          $$payload.out += "<!--[-->";
          const each_array_1 = ensure_array_like(currentQuestionPair);
          $$payload.out += `<!--[-->`;
          for (let $$index_2 = 0, $$length = each_array_1.length; $$index_2 < $$length; $$index_2++) {
            let question = each_array_1[$$index_2];
            if (question.type === "rating") {
              $$payload.out += "<!--[-->";
              const each_array_2 = ensure_array_like(Array(5));
              $$payload.out += `<div class="space-y-2"><p class="font-medium text-center">${escape_html(question.text)}</p> <div class="flex gap-2 justify-center"><!--[-->`;
              for (let i = 0, $$length2 = each_array_2.length; i < $$length2; i++) {
                each_array_2[i];
                $$payload.out += `<button type="button" class="text-2xl transition-colors">`;
                Fa($$payload, {
                  icon: answers[question.id] > i ? faStar : faStar$1,
                  class: answers[question.id] > i ? "text-orange-500" : "text-zinc-600"
                });
                $$payload.out += `<!----></button>`;
              }
              $$payload.out += `<!--]--></div></div>`;
            } else {
              $$payload.out += "<!--[!-->";
            }
            $$payload.out += `<!--]--> `;
            if (question.type === "comment") {
              $$payload.out += "<!--[-->";
              $$payload.out += `<div class="space-y-2"><div class="flex items-center gap-2"><p class="font-medium">${escape_html(question.text)}</p> `;
              if (question.required) {
                $$payload.out += "<!--[-->";
                $$payload.out += `<span class="text-orange-500 text-sm">*</span>`;
              } else {
                $$payload.out += "<!--[!-->";
              }
              $$payload.out += `<!--]--></div> `;
              Textarea($$payload, {
                placeholder: "Shkruani përgjigjen tuaj këtu...",
                rows: "3",
                class: "w-full resize-none",
                value: answers[question.id] || ""
              });
              $$payload.out += `<!----></div>`;
            } else {
              $$payload.out += "<!--[!-->";
            }
            $$payload.out += `<!--]-->`;
          }
          $$payload.out += `<!--]--> `;
          if (currentQuestionPair.every((q) => answers[q.id])) {
            $$payload.out += "<!--[-->";
            $$payload.out += `<div class="text-center mt-4">`;
            Button($$payload, {
              children: ($$payload2) => {
                $$payload2.out += `<!---->Close`;
              },
              $$slots: { default: true }
            });
            $$payload.out += `<!----></div>`;
          } else {
            $$payload.out += "<!--[!-->";
          }
          $$payload.out += `<!--]-->`;
        } else {
          $$payload.out += "<!--[!-->";
        }
        $$payload.out += `<!--]-->`;
      }
      $$payload.out += `<!--]-->`;
    }
    $$payload.out += `<!--]--> `;
    {
      $$payload.out += "<!--[!-->";
    }
    $$payload.out += `<!--]--></div></div></div></div></div></div></div>`;
  } else {
    $$payload.out += "<!--[!-->";
  }
  $$payload.out += `<!--]-->`;
  if ($$store_subs) unsubscribe_stores($$store_subs);
  pop();
}
function _page($$payload, $$props) {
  push();
  var $$store_subs;
  let difficulty = 3;
  let moves = 0;
  let timer = 0;
  let showFeedback = false;
  let currentRound = store_get($$store_subs ??= {}, "$feedbackStore", feedbackStore).currentRound;
  let shouldShowFeedback = false;
  if (store_get($$store_subs ??= {}, "$feedbackStore", feedbackStore).currentRound % 2 === 1 && !feedbackStore.isFeedbackShown(store_get($$store_subs ??= {}, "$feedbackStore", feedbackStore).currentRound)) {
    console.log("📝 Setting up initial feedback for round", store_get($$store_subs ??= {}, "$feedbackStore", feedbackStore).currentRound);
    shouldShowFeedback = true;
    setTimeout(
      () => {
        console.log("📝 Showing initial feedback for round", store_get($$store_subs ??= {}, "$feedbackStore", feedbackStore).currentRound);
        showFeedback = true;
      },
      2e3
    );
  }
  const carImages = [
    "/images/games/puzzle/puzzle1.jpg",
    "/images/games/puzzle/puzzle2.jpg",
    "/images/games/puzzle/puzzle3.jpg",
    "/images/games/puzzle/puzzle4.jpg",
    "/images/games/puzzle/puzzle5.jpg",
    "/images/games/puzzle/puzzle6.jpg",
    "/images/games/puzzle/puzzle7.jpg",
    "/images/games/puzzle/puzzle8.jpg"
  ];
  let selectedImage = null;
  onDestroy(() => {
  });
  if (store_get($$store_subs ??= {}, "$feedbackStore", feedbackStore).currentRound !== currentRound) {
    currentRound = store_get($$store_subs ??= {}, "$feedbackStore", feedbackStore).currentRound;
    console.log("🔄 Round updated from store:", currentRound);
    if (shouldShowFeedback && currentRound % 2 === 1 && !feedbackStore.isFeedbackShown(currentRound)) {
      console.log("📝 Setting up feedback for new round", currentRound);
      setTimeout(
        () => {
          console.log("📝 Showing feedback for round", currentRound);
          showFeedback = true;
        },
        2e3
      );
    }
  }
  let $$settled = true;
  let $$inner_payload;
  function $$render_inner($$payload2) {
    const each_array = ensure_array_like(carImages);
    $$payload2.out += `<div class="h-full flex flex-col"><header class="flex justify-between items-center h-14 px-6 mb-4 bg-gradient-to-r bg-orange-600/10 backdrop-blur-sm border-b border-orange-500/20 rounded-lg"><div class="flex items-center gap-6"><a href="/" class="flex items-center justify-center w-8 h-8 rounded-full hover:bg-orange-500/20 transition-colors">`;
    Fa($$payload2, { icon: faArrowLeft, class: "text-lg" });
    $$payload2.out += `<!----></a> <h1 class="text-xl font-bold tracking-tight">Piece the Puzzle</h1></div> <div class="flex items-center gap-6"><div class="flex items-center gap-2 bg-orange-500/10 px-4 py-2 rounded-lg">`;
    Fa($$payload2, { icon: faGamepad, class: "text-orange-400" });
    $$payload2.out += `<!----> <span class="font-medium">${escape_html(moves)} lëvizje</span></div> <div class="flex items-center gap-2 bg-orange-500/10 px-4 py-2 rounded-lg">`;
    Fa($$payload2, { icon: faClock, class: "text-orange-400" });
    $$payload2.out += `<!----> <span class="font-medium">${escape_html(Math.floor(timer / 60))}:${escape_html((timer % 60).toString().padStart(2, "0"))}</span></div> <div class="flex items-center gap-2 bg-orange-500/10 px-4 py-2 rounded-lg">`;
    Fa($$payload2, { icon: faStairs, class: "text-orange-400" });
    $$payload2.out += `<!----> <span class="font-medium">${escape_html(difficulty)}x${escape_html(difficulty)}</span></div> <div class="w-px h-8 bg-orange-500/20"></div> `;
    Button($$payload2, {
      variant: "ghost",
      size: "icon",
      class: "w-8 h-8 rounded-full hover:bg-orange-500/20",
      children: ($$payload3) => {
        Fa($$payload3, { icon: faGear });
      },
      $$slots: { default: true }
    });
    $$payload2.out += `<!----> `;
    Button($$payload2, {
      variant: "ghost",
      size: "icon",
      class: "w-8 h-8 rounded-full hover:bg-orange-500/20",
      children: ($$payload3) => {
        Fa($$payload3, { icon: faRotateRight });
      },
      $$slots: { default: true }
    });
    $$payload2.out += `<!----></div></header> <div class="flex-1 flex flex-col items-center gap-6 p-4"><div class="flex gap-4 overflow-x-auto p-2 max-w-full"><!--[-->`;
    for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
      let image = each_array[$$index];
      $$payload2.out += `<button${attr("class", `relative w-16 h-16 rounded-lg overflow-hidden border-2 transition-colors hover:border-orange-500 image-select ${stringify(selectedImage === image ? "selected border-orange-500" : "border-transparent")} svelte-1rtqst7`)}><img${attr("src", image)} alt="Car option" class="w-full h-full object-cover"></button>`;
    }
    $$payload2.out += `<!--]--></div> `;
    {
      $$payload2.out += "<!--[!-->";
      {
        $$payload2.out += "<!--[!-->";
      }
      $$payload2.out += `<!--]-->`;
    }
    $$payload2.out += `<!--]--></div></div> `;
    {
      $$payload2.out += "<!--[!-->";
    }
    $$payload2.out += `<!--]--> `;
    {
      $$payload2.out += "<!--[!-->";
    }
    $$payload2.out += `<!--]--> `;
    {
      $$payload2.out += "<!--[!-->";
    }
    $$payload2.out += `<!--]--> `;
    if (showFeedback) {
      $$payload2.out += "<!--[-->";
      GameFeedbackModal($$payload2);
    } else {
      $$payload2.out += "<!--[!-->";
    }
    $$payload2.out += `<!--]-->`;
  }
  do {
    $$settled = true;
    $$inner_payload = copy_payload($$payload);
    $$render_inner($$inner_payload);
  } while (!$$settled);
  assign_payload($$payload, $$inner_payload);
  if ($$store_subs) unsubscribe_stores($$store_subs);
  pop();
}
export {
  _page as default
};
