import { b as push, i as ensure_array_like, e as escape_html, j as attr, k as stringify, p as pop } from './hooks.server-Cv0El8QO.js';
import './client-DOlyn91G.js';
import { F as Fa } from './fa-DdMANGeq.js';
import { faArrowRight, faEdit, faChartBar, faShieldAlt } from '@fortawesome/free-solid-svg-icons';
import './index4-CjZb0xuH.js';
import './exports-DAjI6ZSp.js';

function _page($$payload, $$props) {
  push();
  let userObject = JSON.parse(localStorage.getItem("user"));
  let totalAdmins;
  const adminCards = [
    {
      title: "Editor Pyetesori",
      description: "Modifiko Pyetesorin e faqes se klienteve duke shtuar, edituar dhe hequr pyetje dhe marka makinash.",
      href: "/admin/form-editor",
      color: "from-blue-500/20 to-cyan-500/20 hover:from-blue-500/30 hover:to-cyan-500/30",
      icon: faEdit
    },
    {
      title: "Tabela e Feedback-ut",
      description: "Shiko dhe analizo pergjigjet e klienteve ndaj pyetesorit. Eksporto pergjigjet e klienteve (Te fundit si dhe te kaluara).",
      href: "/admin/feedback",
      color: "from-green-500/20 to-emerald-500/20 hover:from-green-500/30 hover:to-emerald-500/30",
      icon: faChartBar
    },
    {
      title: "Menaxhim Administratoresh",
      description: "Menaxho administratoret qe kane akses ne panelin e adminit. Ky opsion eshte vetem per superAdmin.",
      href: "/admin/users",
      color: "from-purple-500/20 to-pink-500/20 hover:from-purple-500/30 hover:to-pink-500/30",
      icon: faShieldAlt,
      stats: { label: "Admins Aktiv" }
    }
  ];
  const each_array = ensure_array_like(adminCards);
  $$payload.out += `<div class="container flex flex-col items-center justify-center mx-auto h-[calc(100vh-4.8rem)] gap-8 bg-[#111111] p-6"><div class="mb-8"><h1 class="text-3xl font-bold text-white mb-2">Pershendetje, ${escape_html(userObject.user.username)}</h1> <p class="text-gray-400">Zgjidhni një nga opsionet e mëposhtme për të menaxhuar sistemin.</p></div> <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6"><!--[-->`;
  for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
    let card = each_array[$$index];
    $$payload.out += `<button${attr("class", `group relative overflow-hidden rounded-xl bg-gradient-to-br ${stringify(card.color)} border border-white/10 p-6 text-left transition-all duration-300 hover:scale-[1.02] hover:shadow-xl svelte-1ngzkye`)}><div class="relative z-10 h-full flex flex-col justify-start"><div class="flex items-center justify-between mb-4"><div class="p-3 rounded-lg bg-white/10 backdrop-blur">`;
    Fa($$payload, { icon: card.icon, class: "h-6 w-6 text-white" });
    $$payload.out += `<!----></div> `;
    Fa($$payload, {
      icon: faArrowRight,
      class: "h-5 w-5 text-white/50 group-hover:text-white/80 transition-colors"
    });
    $$payload.out += `<!----></div> <h2 class="text-xl font-semibold text-white mb-2">${escape_html(card.title)}</h2> <p class="text-gray-300 text-sm mb-6 line-clamp-2">${escape_html(card.description)}</p> `;
    if (card.stats) {
      $$payload.out += "<!--[-->";
      $$payload.out += `<div class="flex items-center justify-between pt-4 border-t border-white/10"><span class="text-sm text-gray-400">${escape_html(card.stats.label)}</span> <span class="text-lg font-semibold text-white">${escape_html(totalAdmins)}</span></div>`;
    } else {
      $$payload.out += "<!--[!-->";
    }
    $$payload.out += `<!--]--></div> <div class="absolute -bottom-2 -right-2 w-32 h-32 bg-white/5 rounded-full blur-2xl transform group-hover:scale-150 transition-transform duration-500"></div> <div class="absolute -top-2 -left-2 w-24 h-24 bg-white/5 rounded-full blur-xl transform group-hover:scale-150 transition-transform duration-500"></div></button>`;
  }
  $$payload.out += `<!--]--></div></div>`;
  pop();
}

export { _page as default };
//# sourceMappingURL=_page.svelte-ClAVD7nV.js.map
