import { b as push, c as copy_payload, a as assign_payload, p as pop, i as ensure_array_like, e as escape_html, n as spread_props, j as attr, f as bind_props, k as stringify } from './hooks.server-Cv0El8QO.js';
import { o as onDestroy } from './index2-BXnUF5mP.js';
import './client-DOlyn91G.js';
import { T as fallback, O as writable } from './index4-CjZb0xuH.js';
import { F as Fa } from './fa-DdMANGeq.js';
import { faComment, faXmark, faCar, faWrench, faStar, faCheck } from '@fortawesome/free-solid-svg-icons';
import { faStar as faStar$1 } from '@fortawesome/free-regular-svg-icons';
import { T as Textarea } from './textarea-CNLg6aHw.js';
import { s as sessionManager } from './sessionStore-Dp5scwV1.js';
import { B as Button } from './button-B_Dr_1vJ.js';
import './exports-DAjI6ZSp.js';

function createGameStore() {
  const { subscribe, set, update } = writable({
    username: "",
    totalScore: 0,
    gameHistory: [],
    stats: {
      gamesPlayed: 0,
      bestScores: {
        puzzle: 0,
        race: 0,
        pairs: 0,
        trivia: 0
      },
      lastPlayed: null,
      playStreak: 0
    }
  });
  function updatePlayStreak(store) {
    const now = /* @__PURE__ */ new Date();
    const lastPlayed = store.stats.lastPlayed ? new Date(store.stats.lastPlayed) : null;
    if (!lastPlayed) {
      return 1;
    }
    const daysSinceLastPlay = Math.floor((now - lastPlayed) / (1e3 * 60 * 60 * 24));
    if (daysSinceLastPlay === 1) {
      return store.stats.playStreak + 1;
    } else if (daysSinceLastPlay > 1) {
      return 1;
    }
    return store.stats.playStreak;
  }
  return {
    subscribe,
    setUsername: (username) => {
      const savedData = localStorage.getItem(`gameData_${username}`);
      if (savedData) {
        set(JSON.parse(savedData));
      } else {
        update((store) => ({
          ...store,
          username,
          totalScore: 0,
          gameHistory: [],
          stats: {
            gamesPlayed: 0,
            bestScores: {
              puzzle: 0,
              race: 0,
              pairs: 0,
              trivia: 0
            },
            lastPlayed: null,
            playStreak: 0
          }
        }));
      }
    },
    addScore: (game, score) => {
      update((store) => {
        const now = (/* @__PURE__ */ new Date()).toISOString();
        const newGameHistory = [...store.gameHistory, {
          game,
          score,
          timestamp: now
        }];
        const newStats = {
          ...store.stats,
          gamesPlayed: store.stats.gamesPlayed + 1,
          bestScores: {
            ...store.stats.bestScores,
            [game]: Math.max(store.stats.bestScores[game], score)
          },
          lastPlayed: now,
          playStreak: updatePlayStreak(store)
        };
        const newTotalScore = store.totalScore + score;
        const newStore = {
          ...store,
          totalScore: newTotalScore,
          gameHistory: newGameHistory,
          stats: newStats
        };
        localStorage.setItem(`gameData_${store.username}`, JSON.stringify(newStore));
        return newStore;
      });
    },
    getStats: () => {
      let stats;
      update((store) => {
        stats = store.stats;
        return store;
      });
      return stats;
    },
    getGameHistory: () => {
      let history;
      update((store) => {
        history = store.gameHistory;
        return store;
      });
      return history;
    }
  };
}
const gameStore = createGameStore();
function Game_card($$payload, $$props) {
  push();
  let title = fallback($$props["title"], "");
  let image = fallback($$props["image"], "");
  let href = fallback($$props["href"], "");
  $$payload.out += `<div class="game-card svelte-d1z23w" role="button" tabindex="0"><div class="block w-full h-full"><img${attr("src", image)}${attr("alt", title)} class="svelte-d1z23w"> <div class="game-card-content svelte-d1z23w"><h1 class="svelte-d1z23w">${escape_html(title)}</h1></div></div></div>`;
  bind_props($$props, { title, image, href });
  pop();
}
function FeedbackModal($$payload, $$props) {
  push();
  let show = fallback($$props["show"], false);
  let inGameMode = fallback($$props["inGameMode"], false);
  let questions = [];
  let selectedDepartment = localStorage.getItem("selectedDepartment");
  let selectedBrand = localStorage.getItem("selectedBrand");
  let answers = {};
  let isSubmitting = false;
  let formIdMapping = {};
  let brands = [];
  let showQuestions = false;
  sessionManager.subscribe((value) => {
    value.user;
  });
  const loadQuestions = async () => {
    if (selectedDepartment) {
      const response = await fetch(`/api/questions?formId=${formIdMapping[selectedDepartment]}`);
      if (response.ok) {
        const allQuestions = await response.json();
        if (Array.isArray(allQuestions)) {
          questions = allQuestions.sort((a, b) => a.order - b.order);
        }
      }
    }
  };
  if (show) {
    if (selectedDepartment && selectedBrand) {
      showQuestions = true;
      loadQuestions();
    } else {
      showQuestions = false;
    }
  }
  if (show) {
    $$payload.out += "<!--[-->";
    $$payload.out += `<div class="fixed inset-0 z-[9999] overflow-hidden"><button type="button" class="absolute inset-0 bg-black/50 backdrop-blur-sm" aria-label="Close modal"></button> <div class="absolute inset-0 overflow-y-auto"><div class="flex min-h-full items-center justify-center p-4"><div class="relative w-full max-w-xl rounded-xl bg-white dark:bg-zinc-900 shadow-lg"><div class="p-6"><div class="flex justify-between items-center mb-6"><h2 class="text-2xl font-bold">Na ndihmoni të përmirësohemi</h2> `;
    if (!inGameMode) {
      $$payload.out += "<!--[-->";
      $$payload.out += `<button class="p-2 hover:bg-zinc-800 rounded-lg transition-colors">`;
      Fa($$payload, { icon: faXmark, class: "text-xl" });
      $$payload.out += `<!----></button>`;
    } else {
      $$payload.out += "<!--[!-->";
    }
    $$payload.out += `<!--]--></div> `;
    if (!showQuestions) {
      $$payload.out += "<!--[-->";
      const each_array = ensure_array_like(brands);
      $$payload.out += `<form class="space-y-8"><div class="space-y-4"><h3 class="text-lg font-semibold text-center">Cfarë shërbimi kryet?</h3> <div class="grid grid-cols-2 gap-4"><button type="button"${attr("class", `flex flex-col items-center gap-3 p-4 rounded-xl border-2 transition-colors ${stringify(selectedDepartment === "sales" ? "border-orange-500 bg-orange-500/10" : "border-zinc-800 hover:border-orange-500/50")}`)}>`;
      Fa($$payload, { icon: faCar, class: "text-3xl" });
      $$payload.out += `<!----> <span class="font-medium">Shitje</span></button> <button type="button"${attr("class", `flex flex-col items-center gap-3 p-4 rounded-xl border-2 transition-colors ${stringify(selectedDepartment === "service" ? "border-orange-500 bg-orange-500/10" : "border-zinc-800 hover:border-orange-500/50")}`)}>`;
      Fa($$payload, { icon: faWrench, class: "text-3xl" });
      $$payload.out += `<!----> <span class="font-medium">Servis</span></button></div></div> <div class="space-y-4"><h3 class="text-lg font-semibold text-center">Zgjidhni markën tuaj</h3> <div class="grid grid-cols-2 gap-4"><!--[-->`;
      for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
        let brand = each_array[$$index];
        $$payload.out += `<button type="button"${attr("class", `flex flex-col items-center p-4 rounded-xl border-2 transition-colors ${stringify(selectedBrand === brand.id ? "border-orange-500 bg-orange-500/10" : "border-zinc-800 hover:border-orange-500/50")}`)}><img${attr("src", brand.imageUrl)}${attr("alt", brand.name)} class="w-20 h-20 dark:invert"> <span class="font-medium">${escape_html(brand.name)}</span></button>`;
      }
      $$payload.out += `<!--]--></div></div></form>`;
    } else {
      $$payload.out += "<!--[!-->";
      const each_array_1 = ensure_array_like(questions);
      $$payload.out += `<form class="space-y-8"><div class="space-y-6"><!--[-->`;
      for (let $$index_2 = 0, $$length = each_array_1.length; $$index_2 < $$length; $$index_2++) {
        let question = each_array_1[$$index_2];
        $$payload.out += `<div class="space-y-2"><p class="font-medium">${escape_html(question.text)}</p> `;
        if (question.type === "rating") {
          $$payload.out += "<!--[-->";
          const each_array_2 = ensure_array_like(Array(5));
          $$payload.out += `<div class="flex gap-2 justify-center"><!--[-->`;
          for (let i = 0, $$length2 = each_array_2.length; i < $$length2; i++) {
            each_array_2[i];
            $$payload.out += `<button type="button" class="text-2xl transition-colors">`;
            Fa($$payload, {
              icon: answers[question.id] > i ? faStar : faStar$1,
              class: answers[question.id] > i ? "text-orange-500" : "text-zinc-600"
            });
            $$payload.out += `<!----></button>`;
          }
          $$payload.out += `<!--]--></div>`;
        } else {
          $$payload.out += "<!--[!-->";
          if (question.type === "comment") {
            $$payload.out += "<!--[-->";
            Textarea($$payload, {
              placeholder: "Shkruani përgjigjen tuaj këtu...",
              rows: "3",
              class: "w-full resize-none"
            });
          } else {
            $$payload.out += "<!--[!-->";
          }
          $$payload.out += `<!--]-->`;
        }
        $$payload.out += `<!--]--></div>`;
      }
      $$payload.out += `<!--]--></div> `;
      Button($$payload, {
        disabled: isSubmitting,
        class: "w-full",
        children: ($$payload2) => {
          {
            $$payload2.out += "<!--[!-->";
            $$payload2.out += `Dërgo `;
            Fa($$payload2, { icon: faCheck, class: "ml-2" });
            $$payload2.out += `<!---->`;
          }
          $$payload2.out += `<!--]-->`;
        },
        $$slots: { default: true }
      });
      $$payload.out += `<!----></form>`;
    }
    $$payload.out += `<!--]--></div></div></div></div></div>`;
  } else {
    $$payload.out += "<!--[!-->";
  }
  $$payload.out += `<!--]-->`;
  bind_props($$props, { show, inGameMode });
  pop();
}
function _page($$payload, $$props) {
  push();
  let showFeedbackModal = false;
  let selectedDepartment = localStorage.getItem("selectedDepartment");
  localStorage.getItem("selectedBrand");
  let questions;
  let user = null;
  const unsubscribe = sessionManager.subscribe((value) => {
    user = value.user;
    console.log(user);
    user ? user.totalPoints : 0;
  });
  onDestroy(() => {
    unsubscribe();
  });
  const games = [
    {
      title: "PICK\nTHE\nPAIRS",
      href: "/games/pairs",
      image: "/images/games/pairs/cover.png"
    },
    {
      title: "PIECE\nTHE\nPUZZLE",
      href: "/games/puzzle",
      image: "/images/games/puzzle/cover.png"
    },
    {
      title: "RACE\nTHE\nROAD",
      href: "/games/race",
      image: "/images/games/race/cover.png"
    },
    {
      title: "CAR\nTRIVIA",
      href: "/games/trivia",
      image: "/images/games/trivia/cover.png"
    }
  ];
  gameStore.subscribe((state) => {
    state.username;
  });
  if (selectedDepartment) {
    questions[selectedDepartment] || [];
  }
  let $$settled = true;
  let $$inner_payload;
  function $$render_inner($$payload2) {
    const each_array = ensure_array_like(games);
    $$payload2.out += `<div class="container mx-auto px-4 flex flex-col items-center justify-center min-h-[calc(100vh-5rem)] transition-colors duration-300"><div><h1 class="text-3xl font-bold mb-16 text-foreground">LET'S PLAY, ${escape_html(user.username.toUpperCase())}!</h1></div> <div class="grid grid-cols-2 lg:grid-cols-4 gap-4 lg:gap-8 max-w-6xl w-full px-4 lg:px-8"><!--[-->`;
    for (let i = 0, $$length = each_array.length; i < $$length; i++) {
      let game = each_array[i];
      $$payload2.out += `<div>`;
      Game_card($$payload2, spread_props([game]));
      $$payload2.out += `<!----></div>`;
    }
    $$payload2.out += `<!--]--></div> <div class="mt-20"><button class="flex items-center gap-2 px-4 py-2 bg-orange-500 hover:bg-orange-600 text-white rounded-lg font-medium transition-colors">`;
    Fa($$payload2, { icon: faComment, class: "text-lg" });
    $$payload2.out += `<!----> Na ndihmoni të përmirësohemi</button></div> `;
    FeedbackModal($$payload2, {
      get show() {
        return showFeedbackModal;
      },
      set show($$value) {
        showFeedbackModal = $$value;
        $$settled = false;
      }
    });
    $$payload2.out += `<!----></div>`;
  }
  do {
    $$settled = true;
    $$inner_payload = copy_payload($$payload);
    $$render_inner($$inner_payload);
  } while (!$$settled);
  assign_payload($$payload, $$inner_payload);
  pop();
}

export { _page as default };
//# sourceMappingURL=_page.svelte-hzNlGeKn.js.map
