import { createRequire } from 'module';
import { j as json } from './index-BIAFQWR9.js';

const require2 = createRequire(import.meta.url);
const { PrismaClient } = require2("@prisma/client");
const prisma = new PrismaClient();
const PATCH = async ({ request }) => {
  const questions = await request.json();
  try {
    const updatePromises = questions.map(
      (question) => prisma.question.update({
        where: { id: question.id },
        data: { order: question.order }
      })
    );
    await Promise.all(updatePromises);
    return json({ message: "Questions reordered successfully" });
  } catch (error) {
    console.error("Error reordering questions:", error);
    return json({ message: "Could not reorder questions", error: error.message }, { status: 500 });
  }
};

export { PATCH };
//# sourceMappingURL=_server-CBjq-BdK.js.map
