import { j as json } from './index-BIAFQWR9.js';
import { createRequire } from 'module';

const require2 = createRequire(import.meta.url);
const { PrismaClient } = require2("@prisma/client");
const prisma = new PrismaClient();
const GET = async ({ params }) => {
  const { id } = params;
  const admin = await prisma.admin.findUnique({
    where: { id }
  });
  if (!admin) {
    return json({ message: "Admin not found" }, { status: 404 });
  }
  return json(admin);
};
const PATCH = async ({ params, request }) => {
  const { id } = params;
  const updates = await request.json();
  try {
    const updatedAdmin = await prisma.admin.update({
      where: { id },
      data: {
        ...updates,
        updatedAt: /* @__PURE__ */ new Date()
        // Update the timestamp if needed
      }
    });
    return json(updatedAdmin);
  } catch (error) {
    console.error("Error updating admin:", error);
    return json({ message: "Admin not found or could not be updated" }, { status: 404 });
  }
};
const DELETE = async ({ params }) => {
  const { id } = params;
  try {
    await prisma.admin.delete({
      where: { id }
    });
    return json({ message: "Admin deleted" });
  } catch (error) {
    console.error("Error deleting admin:", error);
    return json({ message: "Admin not found or could not be deleted" }, { status: 404 });
  }
};

export { DELETE, GET, PATCH };
//# sourceMappingURL=_server-CIwemkCd.js.map
