import { j as json } from './index-BIAFQWR9.js';
import { createRequire } from 'module';
import bcrypt from 'bcrypt';
import jwt from 'jsonwebtoken';

const require2 = createRequire(import.meta.url);
const { PrismaClient } = require2("@prisma/client");
const prisma = new PrismaClient();
const POST = async ({ request }) => {
  try {
    const { login, password } = await request.json();
    console.log(`Admin login attempt: ${JSON.stringify({ login, password })}`);
    const admin = await prisma.admin.findFirst({
      where: {
        OR: [
          { username: login },
          { email: login }
        ]
      }
    });
    if (!admin) {
      return json({ message: "Invalid login information" }, { status: 401 });
    }
    if (!await verifyPassword(password, admin.password)) {
      return json({ message: "Invalid login information" }, { status: 401 });
    }
    const token = jwt.sign({
      id: admin.id,
      username: admin.username,
      email: admin.email,
      role: admin.role
    }, process.env.JWT_SECRET, {
      expiresIn: "2h"
    });
    return json({
      message: "Login successful",
      token,
      // Return the JWT token
      user: {
        id: admin.id,
        username: admin.username,
        email: admin.email,
        role: admin.role
      }
    });
  } catch (error) {
    console.error("Error during admin login:", error);
    return json({ message: "Internal server error" }, { status: 500 });
  }
};
const verifyPassword = async (password, hash) => {
  return await bcrypt.compare(password, hash);
};

export { POST };
//# sourceMappingURL=_server-CQ34scSn.js.map
