import { O as writable } from './index4-CjZb0xuH.js';

function createThemeStore() {
  const storedTheme = typeof localStorage !== "undefined" ? localStorage.getItem("theme") : "light";
  const initialTheme = storedTheme || "light";
  const { subscribe, set, update } = writable(initialTheme);
  return {
    subscribe,
    set: (value) => {
      if (typeof localStorage !== "undefined") {
        localStorage.setItem("theme", value);
      }
      set(value);
    },
    toggle: () => update((theme2) => {
      const newTheme = theme2 === "light" ? "dark" : "light";
      if (typeof localStorage !== "undefined") {
        localStorage.setItem("theme", newTheme);
      }
      return newTheme;
    })
  };
}
const theme = createThemeStore();

export { theme as t };
//# sourceMappingURL=theme-BoZHI6dT.js.map
