/// <reference types="svelte" />
import type { MeltActionReturn } from '../../internal/types.js';
import type { CheckboxEvents } from './events.js';
import type { CreateCheckboxProps } from './types.js';
export declare function createCheckbox(props?: CreateCheckboxProps): {
    elements: {
        root: import("../../internal/helpers/index.js").MeltElement<[{
            update: (updater: import("svelte/store").Updater<boolean | "indeterminate">, sideEffect?: ((newValue: boolean | "indeterminate") => void) | undefined) => void;
            set: (this: void, value: boolean | "indeterminate") => void;
            subscribe(this: void, run: import("svelte/store").Subscriber<boolean | "indeterminate">, invalidate?: import("svelte/store").Invalidator<boolean | "indeterminate"> | undefined): import("svelte/store").Unsubscriber;
            get: () => boolean | "indeterminate";
            destroy?: (() => void) | undefined;
        }, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<boolean>>, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<boolean>>], (node: HTMLElement) => MeltActionReturn<CheckboxEvents['root']>, ([$checked, $disabled, $required]: [boolean | "indeterminate", boolean, boolean]) => {
            readonly 'data-disabled': true | undefined;
            readonly disabled: true | undefined;
            readonly 'data-state': "indeterminate" | "checked" | "unchecked";
            readonly type: "button";
            readonly role: "checkbox";
            readonly 'aria-checked': boolean | "mixed";
            readonly 'aria-required': boolean;
        }, "checkbox">;
        input: import("../../internal/helpers/index.js").MeltElement<[{
            update: (updater: import("svelte/store").Updater<boolean | "indeterminate">, sideEffect?: ((newValue: boolean | "indeterminate") => void) | undefined) => void;
            set: (this: void, value: boolean | "indeterminate") => void;
            subscribe(this: void, run: import("svelte/store").Subscriber<boolean | "indeterminate">, invalidate?: import("svelte/store").Invalidator<boolean | "indeterminate"> | undefined): import("svelte/store").Unsubscriber;
            get: () => boolean | "indeterminate";
            destroy?: (() => void) | undefined;
        }, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<string | undefined>>, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<string>>, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<boolean>>, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<boolean>>], import("svelte/action").Action<any, any, Record<never, any>>, ([$checked, $name, $value, $required, $disabled]: [boolean | "indeterminate", string | undefined, string, boolean, boolean]) => {
            readonly type: "checkbox";
            readonly 'aria-hidden': true;
            readonly hidden: true;
            readonly tabindex: -1;
            readonly name: string | undefined;
            readonly value: string;
            readonly checked: boolean;
            readonly required: boolean;
            readonly disabled: true | undefined;
            readonly style: string;
        }, "checkbox-input">;
    };
    states: {
        checked: {
            update: (updater: import("svelte/store").Updater<boolean | "indeterminate">, sideEffect?: ((newValue: boolean | "indeterminate") => void) | undefined) => void;
            set: (this: void, value: boolean | "indeterminate") => void;
            subscribe(this: void, run: import("svelte/store").Subscriber<boolean | "indeterminate">, invalidate?: import("svelte/store").Invalidator<boolean | "indeterminate"> | undefined): import("svelte/store").Unsubscriber;
            get: () => boolean | "indeterminate";
            destroy?: (() => void) | undefined;
        };
    };
    helpers: {
        isIndeterminate: import("svelte/store").Readable<boolean>;
        isChecked: import("svelte/store").Readable<boolean>;
    };
    options: import("../../internal/helpers/index.js").ToWritableStores<Omit<{
        disabled: boolean;
        required: boolean;
        name: string | undefined;
        value: string;
        defaultChecked: boolean | "indeterminate";
        checked?: import("svelte/store").Writable<boolean | "indeterminate"> | undefined;
        onCheckedChange?: import("../../internal/helpers/index.js").ChangeFn<boolean | "indeterminate"> | undefined;
    }, "defaultChecked" | "checked">>;
};
