import { type Formatter, type Granularity } from '../../../internal/helpers/date/index.js';
import type { DateValue } from '@internationalized/date';
import type { DateSegmentPart, SegmentContentObj, EditableSegmentPart, SegmentStateMap, SegmentValueObj, DateAndTimeSegmentObj, DayPeriod, SegmentPart, HourCycle } from './types.js';
import { type Writable } from 'svelte/store';
export declare function initializeSegmentValues(granularity: Granularity): SegmentValueObj;
type SharedContentProps = {
    granularity: Granularity;
    dateRef: DateValue;
    formatter: Formatter;
    hideTimeZone: boolean;
    hourCycle: HourCycle;
};
type CreateContentObjProps = SharedContentProps & {
    segmentValues: SegmentValueObj;
    locale: string;
};
type CreateContentProps = CreateContentObjProps;
export declare function createContent(props: CreateContentProps): {
    obj: SegmentContentObj;
    arr: {
        part: SegmentPart;
        value: string;
    }[];
};
export declare function initSegmentStates(): SegmentStateMap;
export declare function initSegmentIds(): {
    label: string;
    description: string;
    day: string;
    hour: string;
    minute: string;
    second: string;
    month: string;
    year: string;
    dayPeriod: string;
    timeZoneName: string;
    field: string;
    validation: string;
};
export declare function isDateSegmentPart(part: unknown): part is DateSegmentPart;
export declare function isSegmentPart(part: string): part is EditableSegmentPart;
export declare function isAnySegmentPart(part: unknown): part is SegmentPart;
type GetValueFromSegments = {
    segmentObj: SegmentValueObj;
    id: string;
    dateRef: DateValue;
};
export declare function getValueFromSegments(props: GetValueFromSegments): DateValue;
/**
 * Check if all the segments being used have been filled.
 * We use this to determine when we should set the value
 * store of the date field(s).
 *
 * @param segmentValues - The current `SegmentValueObj`
 * @param id  - The id of the date field
 */
export declare function areAllSegmentsFilled(segmentValues: SegmentValueObj, id: string): boolean;
/**
 * Extracts the segment part from the provided node,
 * if it exists, otherwise returns null.
 */
export declare function getPartFromNode(node: HTMLElement): SegmentPart | null;
/**
 * Determines if the provided object is a valid `DateAndTimeSegmentObj`
 * by checking if it has the correct keys and values for each key.
 */
export declare function isDateAndTimeSegmentObj(obj: unknown): obj is DateAndTimeSegmentObj;
/**
 * Infer the granularity to use based on the
 * value and granularity props.
 */
export declare function inferGranularity(value: DateValue, granularity: Granularity | undefined): Granularity;
export declare function isAcceptableSegmentKey(key: string): boolean;
type SyncSegmentValuesProps = {
    value: DateValue;
    updatingDayPeriod: Writable<DayPeriod>;
    segmentValues: Writable<SegmentValueObj>;
    formatter: Formatter;
};
/**
 * Sets the individual segment values based on the current
 * value of the date picker. This is used to initialize the
 * segment values if a default value is provided, and to
 * keep it in sync as the value changes outside the builder.
 */
export declare function syncSegmentValues(props: SyncSegmentValuesProps): void;
/**
 * Determines if the element with the provided id is the first focusable
 * segment in the date field with the provided fieldId.
 *
 * @param id - The id of the element to check if it's the first segment
 * @param fieldId - The id of the date field associated with the segment
 */
export declare function isFirstSegment(id: string, fieldId: string): boolean;
/**
 * Creates or updates a description element for a date field
 * which enables screen readers to read the date field's value.
 *
 * This element is hidden from view, and is portalled to the body
 * so it can be associated via `aria-describedby` and read by
 * screen readers as the user interacts with the date field.
 */
export declare function setDescription(id: string, formatter: Formatter, value: DateValue): void;
/**
 * Removes the description element for the date field with
 * the provided ID. This function should be called when the
 * date field is unmounted.
 */
export declare function removeDescriptionElement(id: string): void;
export {};
