/// <reference types="svelte" />
import type { MeltActionReturn, TextDirection } from '../../internal/types.js';
import { type Writable } from 'svelte/store';
import { type WithGet } from '../../internal/helpers/withGet.js';
import type { MenuEvents } from './events.js';
import type { Selector, _CheckboxItemProps, _CreateRadioGroupProps, _CreateSubmenuProps, _MenuBuilderOptions, _RadioItemProps } from './types.js';
export declare const SUB_OPEN_KEYS: Record<TextDirection, string[]>;
export declare const SUB_CLOSE_KEYS: Record<TextDirection, string[]>;
export declare const menuIdParts: readonly ["menu", "trigger"];
export type _MenuIdParts = typeof menuIdParts;
export declare function createMenuBuilder(opts: _MenuBuilderOptions): {
    elements: {
        trigger: import("../../internal/helpers/index.js").MeltElement<[WithGet<Writable<boolean>>, WithGet<Writable<string>>, WithGet<Writable<string>>], (node: HTMLElement) => MeltActionReturn<MenuEvents['trigger']>, ([$rootOpen, $rootMenuId, $rootTriggerId]: [boolean, string, string]) => {
            readonly 'aria-controls': string;
            readonly 'aria-expanded': boolean;
            readonly 'data-state': "open" | "closed";
            readonly id: string;
            readonly tabindex: 0;
        }, string>;
        menu: import("../../internal/helpers/index.js").MeltElement<[import("svelte/store").Readable<boolean>, WithGet<Writable<string | HTMLElement | null | undefined>>, WithGet<Writable<string>>, WithGet<Writable<string>>], (node: HTMLElement) => MeltActionReturn<MenuEvents['menu']>, ([$isVisible, $portal, $rootMenuId, $rootTriggerId]: [boolean, string | HTMLElement | null | undefined, string, string]) => {
            readonly role: "menu";
            readonly hidden: true | undefined;
            readonly style: string;
            readonly id: string;
            readonly 'aria-labelledby': string;
            readonly 'data-state': "open" | "closed";
            readonly 'data-portal': "" | undefined;
            readonly tabindex: -1;
        }, string>;
        overlay: import("../../internal/helpers/index.js").MeltElement<[import("svelte/store").Readable<boolean>], <Node_1 extends any>(node: HTMLElement) => {
            destroy(): void;
        }, ([$isVisible]: [boolean]) => {
            readonly hidden: true | undefined;
            readonly tabindex: -1;
            readonly style: string;
            readonly 'aria-hidden': "true";
            readonly 'data-state': "open" | "closed";
        }, string>;
        item: import("../../internal/helpers/index.js").MeltElement<import("svelte/store").Stores | undefined, (node: HTMLElement) => MeltActionReturn<MenuEvents['item']>, () => {
            role: string;
            tabindex: number;
            'data-orientation': string;
        }, string>;
        group: import("../../internal/helpers/index.js").MeltElement<import("svelte/store").Stores | undefined, import("svelte/action").Action<any, any, Record<never, any>>, () => (groupId: string) => {
            role: string;
            'aria-labelledby': string;
        }, string>;
        groupLabel: import("../../internal/helpers/index.js").MeltElement<import("svelte/store").Stores | undefined, import("svelte/action").Action<any, any, Record<never, any>>, () => (groupId: string) => {
            id: string;
        }, string>;
        arrow: import("../../internal/helpers/index.js").MeltElement<WithGet<Writable<number | undefined>>, import("svelte/action").Action<any, any, Record<never, any>>, ($arrowSize: number | undefined) => {
            'data-arrow': boolean;
            style: string;
        }, string>;
        separator: import("../../internal/helpers/index.js").MeltElement<[WithGet<Writable<import("../../internal/types.js").Orientation>>, WithGet<Writable<boolean>>], import("svelte/action").Action<any, any, Record<never, any>>, ([$orientation, $decorative]: [import("../../internal/types.js").Orientation, boolean]) => {
            role: string;
            'aria-orientation': "vertical" | undefined;
            'aria-hidden': boolean;
            'data-orientation': import("../../internal/types.js").Orientation;
        }, "separator">;
    };
    builders: {
        createCheckboxItem: (props?: _CheckboxItemProps) => {
            elements: {
                checkboxItem: import("../../internal/helpers/index.js").MeltElement<[{
                    update: (updater: import("svelte/store").Updater<boolean | "indeterminate">, sideEffect?: ((newValue: boolean | "indeterminate") => void) | undefined) => void;
                    set: (this: void, value: boolean | "indeterminate") => void;
                    subscribe(this: void, run: import("svelte/store").Subscriber<boolean | "indeterminate">, invalidate?: import("svelte/store").Invalidator<boolean | "indeterminate"> | undefined): import("svelte/store").Unsubscriber;
                    get: () => boolean | "indeterminate";
                    destroy?: (() => void) | undefined;
                }, Writable<boolean>], (node: HTMLElement) => MeltActionReturn<MenuEvents['checkboxItem']>, ([$checked, $disabled]: [boolean | "indeterminate", boolean]) => {
                    readonly role: "menuitemcheckbox";
                    readonly tabindex: -1;
                    readonly 'data-orientation': "vertical";
                    readonly 'aria-checked': "true" | "mixed" | "false";
                    readonly 'data-disabled': true | undefined;
                    readonly 'data-state': "indeterminate" | "checked" | "unchecked";
                }, string>;
            };
            states: {
                checked: {
                    update: (updater: import("svelte/store").Updater<boolean | "indeterminate">, sideEffect?: ((newValue: boolean | "indeterminate") => void) | undefined) => void;
                    set: (this: void, value: boolean | "indeterminate") => void;
                    subscribe(this: void, run: import("svelte/store").Subscriber<boolean | "indeterminate">, invalidate?: import("svelte/store").Invalidator<boolean | "indeterminate"> | undefined): import("svelte/store").Unsubscriber;
                    get: () => boolean | "indeterminate";
                    destroy?: (() => void) | undefined;
                };
            };
            helpers: {
                isChecked: import("svelte/store").Readable<boolean>;
                isIndeterminate: import("svelte/store").Readable<boolean>;
            };
            options: {
                disabled: Writable<boolean>;
            };
        };
        createSubmenu: (args?: _CreateSubmenuProps) => {
            ids: import("../../internal/helpers/index.js").ToWritableStores<{
                menu: string;
                trigger: string;
            }>;
            elements: {
                subTrigger: import("../../internal/helpers/index.js").MeltElement<[{
                    update: (updater: import("svelte/store").Updater<boolean>, sideEffect?: ((newValue: boolean) => void) | undefined) => void;
                    set: (this: void, value: boolean) => void;
                    subscribe(this: void, run: import("svelte/store").Subscriber<boolean>, invalidate?: import("svelte/store").Invalidator<boolean> | undefined): import("svelte/store").Unsubscriber;
                    get: () => boolean;
                    destroy?: (() => void) | undefined;
                }, WithGet<Writable<boolean>>, WithGet<Writable<string>>, WithGet<Writable<string>>], (node: HTMLElement) => MeltActionReturn<MenuEvents['subTrigger']>, ([$subOpen, $disabled, $subMenuId, $subTriggerId]: [boolean, boolean, string, string]) => {
                    readonly role: "menuitem";
                    readonly id: string;
                    readonly tabindex: -1;
                    readonly 'aria-controls': string;
                    readonly 'aria-expanded': boolean;
                    readonly 'data-state': "open" | "closed";
                    readonly 'data-disabled': true | undefined;
                    readonly 'aria-haspopop': "menu";
                }, string>;
                subMenu: import("../../internal/helpers/index.js").MeltElement<[import("svelte/store").Readable<boolean>, WithGet<Writable<string>>, WithGet<Writable<string>>], (node: HTMLElement) => MeltActionReturn<MenuEvents['submenu']>, ([$subIsVisible, $subMenuId, $subTriggerId]: [boolean, string, string]) => {
                    readonly role: "menu";
                    readonly hidden: true | undefined;
                    readonly style: string;
                    readonly id: string;
                    readonly 'aria-labelledby': string;
                    readonly 'data-state': "open" | "closed";
                    readonly 'data-id': string;
                    readonly tabindex: -1;
                }, string>;
                subArrow: import("../../internal/helpers/index.js").MeltElement<WithGet<Writable<number>>, import("svelte/action").Action<any, any, Record<never, any>>, ($arrowSize: number) => {
                    'data-arrow': boolean;
                    style: string;
                }, string>;
            };
            states: {
                subOpen: {
                    update: (updater: import("svelte/store").Updater<boolean>, sideEffect?: ((newValue: boolean) => void) | undefined) => void;
                    set: (this: void, value: boolean) => void;
                    subscribe(this: void, run: import("svelte/store").Subscriber<boolean>, invalidate?: import("svelte/store").Invalidator<boolean> | undefined): import("svelte/store").Unsubscriber;
                    get: () => boolean;
                    destroy?: (() => void) | undefined;
                };
            };
            options: import("../../internal/helpers/index.js").ToWritableStores<Omit<{
                open?: Writable<boolean> | undefined;
                ids?: Partial<{
                    menu: string;
                    trigger: string;
                }> | undefined;
                onOpenChange?: import("../../internal/helpers/index.js").ChangeFn<boolean> | undefined;
                positioning: import("../../internal/actions/index.js").FloatingConfig | {
                    placement: "right-start";
                    gutter: number;
                };
                arrowSize: number;
                disabled: boolean;
                preventScroll: true;
                closeOnEscape: true;
                closeOnOutsideClick: true;
                portal: undefined;
                loop: false;
                dir: "ltr";
                defaultOpen: false;
                typeahead: true;
                closeOnItemClick: true;
                onOutsideClick: undefined;
            }, "ids">>;
        };
        createMenuRadioGroup: (args?: _CreateRadioGroupProps) => {
            elements: {
                radioGroup: import("../../internal/helpers/index.js").MeltElement<import("svelte/store").Stores | undefined, import("svelte/action").Action<any, any, Record<never, any>>, () => {
                    role: string;
                }, string>;
                radioItem: import("../../internal/helpers/index.js").MeltElement<[{
                    update: (updater: import("svelte/store").Updater<string | null>, sideEffect?: ((newValue: string | null) => void) | undefined) => void;
                    set: (this: void, value: string | null) => void;
                    subscribe(this: void, run: import("svelte/store").Subscriber<string | null>, invalidate?: import("svelte/store").Invalidator<string | null> | undefined): import("svelte/store").Unsubscriber;
                    get: () => string | null;
                    destroy?: (() => void) | undefined;
                }], (node: HTMLElement) => MeltActionReturn<MenuEvents['radioItem']>, ([$value]: [string | null]) => (itemProps: _RadioItemProps) => {
                    disabled: boolean;
                    role: string;
                    'data-state': string;
                    'aria-checked': boolean;
                    'data-disabled': boolean | undefined;
                    'data-value': string;
                    'data-orientation': string;
                    tabindex: number;
                }, string>;
            };
            states: {
                value: {
                    update: (updater: import("svelte/store").Updater<string | null>, sideEffect?: ((newValue: string | null) => void) | undefined) => void;
                    set: (this: void, value: string | null) => void;
                    subscribe(this: void, run: import("svelte/store").Subscriber<string | null>, invalidate?: import("svelte/store").Invalidator<string | null> | undefined): import("svelte/store").Unsubscriber;
                    get: () => string | null;
                    destroy?: (() => void) | undefined;
                };
            };
            helpers: {
                isChecked: import("svelte/store").Readable<(itemValue: string) => boolean>;
            };
        };
    };
    states: {
        open: WithGet<Writable<boolean>>;
    };
    helpers: {
        handleTypeaheadSearch: (key: string, items: HTMLElement[]) => void;
    };
    ids: import("../../internal/helpers/index.js").ToWritableStores<{
        menu: string;
        trigger: string;
    }>;
    options: {
        positioning: WithGet<Writable<import("../../internal/actions/index.js").FloatingConfig>>;
        arrowSize: WithGet<Writable<number | undefined>>;
        preventScroll: WithGet<Writable<boolean | undefined>>;
        loop: WithGet<Writable<boolean | undefined>>;
        dir: WithGet<Writable<TextDirection>>;
        closeOnEscape: WithGet<Writable<boolean>>;
        closeOnOutsideClick: WithGet<Writable<boolean>>;
        portal: WithGet<Writable<string | HTMLElement | null | undefined>>;
        forceVisible: WithGet<Writable<boolean>>;
        typeahead: WithGet<Writable<boolean>>;
        closeFocus: WithGet<Writable<import("../../internal/helpers/index.js").FocusProp | undefined>>;
        disableFocusFirstItem: WithGet<Writable<boolean>>;
        closeOnItemClick: WithGet<Writable<boolean>>;
        onOutsideClick: WithGet<Writable<((event: import("../../internal/actions/index.js").InteractOutsideEvent) => void) | undefined>>;
    };
};
export declare function handleTabNavigation(e: KeyboardEvent, nextFocusable: WithGet<Writable<HTMLElement | null>>, prevFocusable: WithGet<Writable<HTMLElement | null>>): void;
/**
 * Get the menu items for a given menu element.
 * This only selects menu items that are direct children of the menu element,
 * not menu items that are nested in submenus.
 * @param element The menu item element
 */
export declare function getMenuItems(menuElement: HTMLElement): HTMLElement[];
export declare function applyAttrsIfDisabled(element: HTMLElement | null): void;
/**
 * Given a timer store, clear the timeout and set the store to null
 * @param openTimer The timer store
 */
export declare function clearTimerStore(timerStore: WithGet<Writable<number | null>>): void;
/**
 * Set the `data-melt-menu-id` attribute on a menu item element.
 * @param element The menu item element
 */
export declare function setMeltMenuAttribute(element: HTMLElement | null, selector: Selector): void;
/**
 * Keyboard event handler for menu navigation
 * @param e The keyboard event
 */
export declare function handleMenuNavigation(e: KeyboardEvent, loop?: boolean): void;
export type Point = {
    x: number;
    y: number;
};
