/// <reference types="svelte" />
import type { MeltActionReturn } from '../../internal/types.js';
import type { ToggleGroupEvents } from './events.js';
import type { CreateToggleGroupProps, ToggleGroupItemProps, ToggleGroupType } from './types.js';
export declare const createToggleGroup: <T extends ToggleGroupType = "single">(props?: CreateToggleGroupProps<T> | undefined) => {
    elements: {
        root: import("../../internal/helpers/index.js").MeltElement<import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<import("../../internal/types.js").Orientation>>, import("svelte/action").Action<any, any, Record<never, any>>, ($orientation: import("../../internal/types.js").Orientation) => {
            readonly role: "group";
            readonly 'data-orientation': import("../../internal/types.js").Orientation;
        }, string>;
        item: import("../../internal/helpers/index.js").MeltElement<[{
            update: (updater: import("svelte/store").Updater<string | string[] | undefined>, sideEffect?: ((newValue: string | string[] | undefined) => void) | undefined) => void;
            set: (this: void, value: string | string[] | undefined) => void;
            subscribe(this: void, run: import("svelte/store").Subscriber<string | string[] | undefined>, invalidate?: import("svelte/store").Invalidator<string | string[] | undefined> | undefined): import("svelte/store").Unsubscriber;
            get: () => string | string[] | undefined;
            destroy?: (() => void) | undefined;
        }, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<boolean>>, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<import("../../internal/types.js").Orientation>>, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<"single" | T>>], (node: HTMLElement) => MeltActionReturn<ToggleGroupEvents['item']>, ([$value, $disabled, $orientation, $type]: [string | string[] | undefined, boolean, import("../../internal/types.js").Orientation, "single" | T]) => (props: ToggleGroupItemProps) => {
            readonly disabled: true | undefined;
            readonly pressed: boolean;
            readonly 'data-orientation': import("../../internal/types.js").Orientation;
            readonly 'data-disabled': true | undefined;
            readonly 'data-state': "on" | "off";
            readonly 'data-value': string;
            readonly 'aria-pressed': boolean | undefined;
            readonly 'aria-checked': boolean | undefined;
            readonly type: "button";
            readonly role: "radio" | undefined;
            readonly tabindex: 0 | -1;
        }, string>;
    };
    states: {
        value: {
            update: (updater: import("svelte/store").Updater<string | string[] | undefined>, sideEffect?: ((newValue: string | string[] | undefined) => void) | undefined) => void;
            set: (this: void, value: string | string[] | undefined) => void;
            subscribe(this: void, run: import("svelte/store").Subscriber<string | string[] | undefined>, invalidate?: import("svelte/store").Invalidator<string | string[] | undefined> | undefined): import("svelte/store").Unsubscriber;
            get: () => string | string[] | undefined;
            destroy?: (() => void) | undefined;
        };
    };
    helpers: {
        isPressed: import("svelte/store").Readable<(itemValue: string) => boolean>;
    };
    options: import("../../internal/helpers/index.js").ToWritableStores<Omit<{
        defaultValue: string | (T extends "single" ? string : string[]);
        value?: import("svelte/store").Writable<string | string[] | undefined> | undefined;
        onValueChange?: import("../../internal/helpers/index.js").ChangeFn<string | string[] | undefined> | undefined;
        type: "single" | T;
        disabled: boolean;
        rovingFocus: boolean;
        loop: boolean;
        orientation: import("../../internal/types.js").Orientation;
    }, "value">>;
};
