/// <reference types="svelte" />
import type { MeltActionReturn } from '../../internal/types.js';
import type { ToggleEvents } from './events.js';
import type { CreateToggleProps } from './types.js';
export declare function createToggle(props?: CreateToggleProps): {
    elements: {
        root: import("../../internal/helpers/index.js").MeltElement<[{
            update: (updater: import("svelte/store").Updater<boolean>, sideEffect?: ((newValue: boolean) => void) | undefined) => void;
            set: (this: void, value: boolean) => void;
            subscribe(this: void, run: import("svelte/store").Subscriber<boolean>, invalidate?: import("svelte/store").Invalidator<boolean> | undefined): import("svelte/store").Unsubscriber;
            get: () => boolean;
            destroy?: (() => void) | undefined;
        }, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<boolean>>], (node: HTMLElement) => MeltActionReturn<ToggleEvents['root']>, ([$pressed, $disabled]: [boolean, boolean]) => {
            readonly 'data-disabled': true | undefined;
            readonly disabled: true | undefined;
            readonly 'data-state': "on" | "off";
            readonly 'aria-pressed': boolean;
            readonly type: "button";
        }, "toggle">;
    };
    states: {
        pressed: {
            update: (updater: import("svelte/store").Updater<boolean>, sideEffect?: ((newValue: boolean) => void) | undefined) => void;
            set: (this: void, value: boolean) => void;
            subscribe(this: void, run: import("svelte/store").Subscriber<boolean>, invalidate?: import("svelte/store").Invalidator<boolean> | undefined): import("svelte/store").Unsubscriber;
            get: () => boolean;
            destroy?: (() => void) | undefined;
        };
    };
    options: import("../../internal/helpers/index.js").ToWritableStores<Omit<{
        disabled: boolean;
        defaultPressed: boolean;
        pressed?: import("svelte/store").Writable<boolean> | undefined;
        onPressedChange?: import("../../internal/helpers/index.js").ChangeFn<boolean> | undefined;
    }, "pressed">>;
};
