import { withGet } from '../withGet.js';
/**
 * A higher order store that encapsulates a writable store holding a `DateValue` from the
 * '@internationalized/date' library. It provides some convenience methods for common
 * date manipulations.
 *
 * @see [@internationalized/date](https://react-spectrum.adobe.com/internationalized/date/index.html)
 */
export function dateStore(store, defaultValue) {
    const { set, update, subscribe, get } = withGet(store);
    function add(duration) {
        update((d) => {
            return d.add(duration);
        });
    }
    function nextPage(amount) {
        update((d) => {
            return d.set({ day: 1 }).add({ months: amount });
        });
    }
    function prevPage(amount) {
        update((d) => {
            return d.set({ day: 1 }).subtract({ months: amount });
        });
    }
    function subtract(duration) {
        update((d) => {
            return d.subtract(duration);
        });
    }
    function setDate(fields, disambiguation) {
        if (disambiguation) {
            update((d) => {
                return d.set(fields, disambiguation);
            });
            return;
        }
        update((d) => {
            return d.set(fields);
        });
    }
    function reset() {
        update(() => {
            return defaultValue;
        });
    }
    function toWritable() {
        return {
            set,
            subscribe,
            update,
            get,
        };
    }
    return {
        get,
        set,
        update,
        subscribe,
        add,
        subtract,
        setDate,
        reset,
        toWritable,
        nextPage,
        prevPage,
    };
}
