export const isBrowser = typeof document !== 'undefined';
// eslint-disable-next-line @typescript-eslint/ban-types
export const isFunction = (v) => typeof v === 'function';
export const isLetter = (key) => /^[a-z]$/i.test(key);
export function isDocument(element) {
    return element instanceof Document;
}
export function isElement(element) {
    return element instanceof Element;
}
export function isHTMLElement(element) {
    return element instanceof HTMLElement;
}
export function isHTMLInputElement(element) {
    return element instanceof HTMLInputElement;
}
export function isHTMLLabelElement(element) {
    return element instanceof HTMLLabelElement;
}
export function isHTMLButtonElement(element) {
    return element instanceof HTMLButtonElement;
}
export function isElementDisabled(element) {
    const ariaDisabled = element.getAttribute('aria-disabled');
    const disabled = element.getAttribute('disabled');
    const dataDisabled = element.hasAttribute('data-disabled');
    if (ariaDisabled === 'true' || disabled !== null || dataDisabled) {
        return true;
    }
    return false;
}
export function isTouch(event) {
    return event.pointerType === 'touch';
}
export function isLeftClick(event) {
    return event.button === 0 && event.ctrlKey === false && event.metaKey === false;
}
export function isFocusVisible(element) {
    return element.matches(':focus-visible');
}
export function isContentEditable(element) {
    if (!isHTMLElement(element))
        return false;
    return element.isContentEditable;
}
export function isNull(value) {
    return value === null;
}
export function isNumberString(value) {
    if (isNaN(parseInt(value)))
        return false;
    return true;
}
export function isObject(value) {
    return value !== null && typeof value === 'object';
}
export function isReadable(value) {
    return isObject(value) && 'subscribe' in value;
}
export function isWritable(value) {
    return isReadable(value) && 'set' in value;
}
