/**
 * @license lucide-svelte v0.469.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
import { SvelteComponentTyped } from "svelte";
import type { IconProps } from '../types.js';
declare const __propDef: {
    props: IconProps;
    events: {
        [evt: string]: CustomEvent<any>;
    };
    slots: {
        default: {};
    };
};
export type CctvProps = typeof __propDef.props;
export type CctvEvents = typeof __propDef.events;
export type CctvSlots = typeof __propDef.slots;
/**
 * @component @name Cctv
 * @description Lucide SVG icon component, renders SVG Element with children.
 *
 * @preview ![img](data:image/svg+xml;base64,PHN2ZyAgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIgogIHdpZHRoPSIyNCIKICBoZWlnaHQ9IjI0IgogIHZpZXdCb3g9IjAgMCAyNCAyNCIKICBmaWxsPSJub25lIgogIHN0cm9rZT0iIzAwMCIgc3R5bGU9ImJhY2tncm91bmQtY29sb3I6ICNmZmY7IGJvcmRlci1yYWRpdXM6IDJweCIKICBzdHJva2Utd2lkdGg9IjIiCiAgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIgogIHN0cm9rZS1saW5lam9pbj0icm91bmQiCj4KICA8cGF0aCBkPSJNMTYuNzUgMTJoMy42MzJhMSAxIDAgMCAxIC44OTQgMS40NDdsLTIuMDM0IDQuMDY5YTEgMSAwIDAgMS0xLjcwOC4xMzRsLTIuMTI0LTIuOTciIC8+CiAgPHBhdGggZD0iTTE3LjEwNiA5LjA1M2ExIDEgMCAwIDEgLjQ0NyAxLjM0MWwtMy4xMDYgNi4yMTFhMSAxIDAgMCAxLTEuMzQyLjQ0N0wzLjYxIDEyLjNhMi45MiAyLjkyIDAgMCAxLTEuMy0zLjkxTDMuNjkgNS42YTIuOTIgMi45MiAwIDAgMSAzLjkyLTEuM3oiIC8+CiAgPHBhdGggZD0iTTIgMTloMy43NmEyIDIgMCAwIDAgMS44LTEuMUw5IDE1IiAvPgogIDxwYXRoIGQ9Ik0yIDIxdi00IiAvPgogIDxwYXRoIGQ9Ik03IDloLjAxIiAvPgo8L3N2Zz4K) - https://lucide.dev/icons/cctv
 * @see https://lucide.dev/guide/packages/lucide-svelte - Documentation
 *
 * @param {Object} props - Lucide icons props and any valid SVG attribute
 * @returns {FunctionalComponent} Svelte component
 *
 */
export default class Cctv extends SvelteComponentTyped<CctvProps, CctvEvents, CctvSlots> {
}
export {};
