/**
 * @license lucide-svelte v0.469.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
import { SvelteComponentTyped } from "svelte";
import type { IconProps } from '../types.js';
declare const __propDef: {
    props: IconProps;
    events: {
        [evt: string]: CustomEvent<any>;
    };
    slots: {
        default: {};
    };
};
export type PopsicleProps = typeof __propDef.props;
export type PopsicleEvents = typeof __propDef.events;
export type PopsicleSlots = typeof __propDef.slots;
/**
 * @component @name Popsicle
 * @description Lucide SVG icon component, renders SVG Element with children.
 *
 * @preview ![img](data:image/svg+xml;base64,PHN2ZyAgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIgogIHdpZHRoPSIyNCIKICBoZWlnaHQ9IjI0IgogIHZpZXdCb3g9IjAgMCAyNCAyNCIKICBmaWxsPSJub25lIgogIHN0cm9rZT0iIzAwMCIgc3R5bGU9ImJhY2tncm91bmQtY29sb3I6ICNmZmY7IGJvcmRlci1yYWRpdXM6IDJweCIKICBzdHJva2Utd2lkdGg9IjIiCiAgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIgogIHN0cm9rZS1saW5lam9pbj0icm91bmQiCj4KICA8cGF0aCBkPSJNMTguNiAxNC40Yy44LS44LjgtMiAwLTIuOGwtOC4xLTguMWE0Ljk1IDQuOTUgMCAxIDAtNy4xIDcuMWw4LjEgOC4xYy45LjcgMi4xLjcgMi45LS4xWiIgLz4KICA8cGF0aCBkPSJtMjIgMjItNS41LTUuNSIgLz4KPC9zdmc+Cg==) - https://lucide.dev/icons/popsicle
 * @see https://lucide.dev/guide/packages/lucide-svelte - Documentation
 *
 * @param {Object} props - Lucide icons props and any valid SVG attribute
 * @returns {FunctionalComponent} Svelte component
 *
 */
export default class Popsicle extends SvelteComponentTyped<PopsicleProps, PopsicleEvents, PopsicleSlots> {
}
export {};
