/**
 * @license lucide-svelte v0.469.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
import { SvelteComponentTyped } from "svelte";
import type { IconProps } from '../types.js';
declare const __propDef: {
    props: IconProps;
    events: {
        [evt: string]: CustomEvent<any>;
    };
    slots: {
        default: {};
    };
};
export type RadiationProps = typeof __propDef.props;
export type RadiationEvents = typeof __propDef.events;
export type RadiationSlots = typeof __propDef.slots;
/**
 * @component @name Radiation
 * @description Lucide SVG icon component, renders SVG Element with children.
 *
 * @preview ![img](data:image/svg+xml;base64,PHN2ZyAgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIgogIHdpZHRoPSIyNCIKICBoZWlnaHQ9IjI0IgogIHZpZXdCb3g9IjAgMCAyNCAyNCIKICBmaWxsPSJub25lIgogIHN0cm9rZT0iIzAwMCIgc3R5bGU9ImJhY2tncm91bmQtY29sb3I6ICNmZmY7IGJvcmRlci1yYWRpdXM6IDJweCIKICBzdHJva2Utd2lkdGg9IjIiCiAgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIgogIHN0cm9rZS1saW5lam9pbj0icm91bmQiCj4KICA8cGF0aCBkPSJNMTIgMTJoLjAxIiAvPgogIDxwYXRoIGQ9Ik03LjUgNC4yYy0uMy0uNS0uOS0uNy0xLjMtLjRDMy45IDUuNSAyLjMgOC4xIDIgMTFjLS4xLjUuNCAxIDEgMWg1YzAtMS41LjgtMi44IDItMy40LTEuMS0xLjktMi0zLjUtMi41LTQuNHoiIC8+CiAgPHBhdGggZD0iTTIxIDEyYy42IDAgMS0uNCAxLTEtLjMtMi45LTEuOC01LjUtNC4xLTcuMS0uNC0uMy0xLjEtLjItMS4zLjMtLjYuOS0xLjUgMi41LTIuNiA0LjMgMS4yLjcgMiAyIDIgMy41aDV6IiAvPgogIDxwYXRoIGQ9Ik03LjUgMTkuOGMtLjMuNS0uMSAxLjEuNCAxLjMgMi42IDEuMiA1LjYgMS4yIDguMiAwIC41LS4yLjctLjguNC0xLjMtLjUtLjktMS40LTIuNS0yLjUtNC4zLTEuMi43LTIuOC43LTQgMC0xLjEgMS44LTIgMy40LTIuNSA0LjN6IiAvPgo8L3N2Zz4K) - https://lucide.dev/icons/radiation
 * @see https://lucide.dev/guide/packages/lucide-svelte - Documentation
 *
 * @param {Object} props - Lucide icons props and any valid SVG attribute
 * @returns {FunctionalComponent} Svelte component
 *
 */
export default class Radiation extends SvelteComponentTyped<RadiationProps, RadiationEvents, RadiationSlots> {
}
export {};
