/**
 * @license lucide-svelte v0.469.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
import { SvelteComponentTyped } from "svelte";
import type { IconProps } from '../types.js';
declare const __propDef: {
    props: IconProps;
    events: {
        [evt: string]: CustomEvent<any>;
    };
    slots: {
        default: {};
    };
};
export type Rotate_3dProps = typeof __propDef.props;
export type Rotate_3dEvents = typeof __propDef.events;
export type Rotate_3dSlots = typeof __propDef.slots;
/**
 * @component @name Rotate3d
 * @description Lucide SVG icon component, renders SVG Element with children.
 *
 * @preview ![img](data:image/svg+xml;base64,PHN2ZyAgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIgogIHdpZHRoPSIyNCIKICBoZWlnaHQ9IjI0IgogIHZpZXdCb3g9IjAgMCAyNCAyNCIKICBmaWxsPSJub25lIgogIHN0cm9rZT0iIzAwMCIgc3R5bGU9ImJhY2tncm91bmQtY29sb3I6ICNmZmY7IGJvcmRlci1yYWRpdXM6IDJweCIKICBzdHJva2Utd2lkdGg9IjIiCiAgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIgogIHN0cm9rZS1saW5lam9pbj0icm91bmQiCj4KICA8cGF0aCBkPSJNMTYuNDY2IDcuNUMxNS42NDMgNC4yMzcgMTMuOTUyIDIgMTIgMiA5LjIzOSAyIDcgNi40NzcgNyAxMnMyLjIzOSAxMCA1IDEwYy4zNDIgMCAuNjc3LS4wNjkgMS0uMiIgLz4KICA8cGF0aCBkPSJtMTUuMTk0IDEzLjcwNyAzLjgxNCAxLjg2LTEuODYgMy44MTQiIC8+CiAgPHBhdGggZD0iTTE5IDE1LjU3Yy0xLjgwNC44ODUtNC4yNzQgMS40My03IDEuNDMtNS41MjMgMC0xMC0yLjIzOS0xMC01czQuNDc3LTUgMTAtNWM0LjgzOCAwIDguODczIDEuNzE4IDkuOCA0IiAvPgo8L3N2Zz4K) - https://lucide.dev/icons/rotate-3d
 * @see https://lucide.dev/guide/packages/lucide-svelte - Documentation
 *
 * @param {Object} props - Lucide icons props and any valid SVG attribute
 * @returns {FunctionalComponent} Svelte component
 *
 */
export default class Rotate_3d extends SvelteComponentTyped<Rotate_3dProps, Rotate_3dEvents, Rotate_3dSlots> {
}
export {};
