/**
 * @license lucide-svelte v0.469.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
import { SvelteComponentTyped } from "svelte";
import type { IconProps } from '../types.js';
declare const __propDef: {
    props: IconProps;
    events: {
        [evt: string]: CustomEvent<any>;
    };
    slots: {
        default: {};
    };
};
export type SoupProps = typeof __propDef.props;
export type SoupEvents = typeof __propDef.events;
export type SoupSlots = typeof __propDef.slots;
/**
 * @component @name Soup
 * @description Lucide SVG icon component, renders SVG Element with children.
 *
 * @preview ![img](data:image/svg+xml;base64,PHN2ZyAgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIgogIHdpZHRoPSIyNCIKICBoZWlnaHQ9IjI0IgogIHZpZXdCb3g9IjAgMCAyNCAyNCIKICBmaWxsPSJub25lIgogIHN0cm9rZT0iIzAwMCIgc3R5bGU9ImJhY2tncm91bmQtY29sb3I6ICNmZmY7IGJvcmRlci1yYWRpdXM6IDJweCIKICBzdHJva2Utd2lkdGg9IjIiCiAgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIgogIHN0cm9rZS1saW5lam9pbj0icm91bmQiCj4KICA8cGF0aCBkPSJNMTIgMjFhOSA5IDAgMCAwIDktOUgzYTkgOSAwIDAgMCA5IDlaIiAvPgogIDxwYXRoIGQ9Ik03IDIxaDEwIiAvPgogIDxwYXRoIGQ9Ik0xOS41IDEyIDIyIDYiIC8+CiAgPHBhdGggZD0iTTE2LjI1IDNjLjI3LjEuOC41My43NSAxLjM2LS4wNi44My0uOTMgMS4yLTEgMi4wMi0uMDUuNzguMzQgMS4yNC43MyAxLjYyIiAvPgogIDxwYXRoIGQ9Ik0xMS4yNSAzYy4yNy4xLjguNTMuNzQgMS4zNi0uMDUuODMtLjkzIDEuMi0uOTggMi4wMi0uMDYuNzguMzMgMS4yNC43MiAxLjYyIiAvPgogIDxwYXRoIGQ9Ik02LjI1IDNjLjI3LjEuOC41My43NSAxLjM2LS4wNi44My0uOTMgMS4yLTEgMi4wMi0uMDUuNzguMzQgMS4yNC43NCAxLjYyIiAvPgo8L3N2Zz4K) - https://lucide.dev/icons/soup
 * @see https://lucide.dev/guide/packages/lucide-svelte - Documentation
 *
 * @param {Object} props - Lucide icons props and any valid SVG attribute
 * @returns {FunctionalComponent} Svelte component
 *
 */
export default class Soup extends SvelteComponentTyped<SoupProps, SoupEvents, SoupSlots> {
}
export {};
