/**
 * @license lucide-svelte v0.469.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
import { SvelteComponentTyped } from "svelte";
import type { IconProps } from '../types.js';
declare const __propDef: {
    props: IconProps;
    events: {
        [evt: string]: CustomEvent<any>;
    };
    slots: {
        default: {};
    };
};
export type TableRowsSplitProps = typeof __propDef.props;
export type TableRowsSplitEvents = typeof __propDef.events;
export type TableRowsSplitSlots = typeof __propDef.slots;
/**
 * @component @name TableRowsSplit
 * @description Lucide SVG icon component, renders SVG Element with children.
 *
 * @preview ![img](data:image/svg+xml;base64,PHN2ZyAgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIgogIHdpZHRoPSIyNCIKICBoZWlnaHQ9IjI0IgogIHZpZXdCb3g9IjAgMCAyNCAyNCIKICBmaWxsPSJub25lIgogIHN0cm9rZT0iIzAwMCIgc3R5bGU9ImJhY2tncm91bmQtY29sb3I6ICNmZmY7IGJvcmRlci1yYWRpdXM6IDJweCIKICBzdHJva2Utd2lkdGg9IjIiCiAgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIgogIHN0cm9rZS1saW5lam9pbj0icm91bmQiCj4KICA8cGF0aCBkPSJNMTQgMTBoMiIgLz4KICA8cGF0aCBkPSJNMTUgMjJ2LTgiIC8+CiAgPHBhdGggZD0iTTE1IDJ2NCIgLz4KICA8cGF0aCBkPSJNMiAxMGgyIiAvPgogIDxwYXRoIGQ9Ik0yMCAxMGgyIiAvPgogIDxwYXRoIGQ9Ik0zIDE5aDE4IiAvPgogIDxwYXRoIGQ9Ik0zIDIydi02YTIgMiAxMzUgMCAxIDItMmgxNGEyIDIgNDUgMCAxIDIgMnY2IiAvPgogIDxwYXRoIGQ9Ik0zIDJ2MmEyIDIgNDUgMCAwIDIgMmgxNGEyIDIgMTM1IDAgMCAyLTJWMiIgLz4KICA8cGF0aCBkPSJNOCAxMGgyIiAvPgogIDxwYXRoIGQ9Ik05IDIydi04IiAvPgogIDxwYXRoIGQ9Ik05IDJ2NCIgLz4KPC9zdmc+Cg==) - https://lucide.dev/icons/table-rows-split
 * @see https://lucide.dev/guide/packages/lucide-svelte - Documentation
 *
 * @param {Object} props - Lucide icons props and any valid SVG attribute
 * @returns {FunctionalComponent} Svelte component
 *
 */
export default class TableRowsSplit extends SvelteComponentTyped<TableRowsSplitProps, TableRowsSplitEvents, TableRowsSplitSlots> {
}
export {};
