/**
 * @license lucide-svelte v0.469.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
import { SvelteComponentTyped } from "svelte";
import type { IconProps } from '../types.js';
declare const __propDef: {
    props: IconProps;
    events: {
        [evt: string]: CustomEvent<any>;
    };
    slots: {
        default: {};
    };
};
export type WebhookOffProps = typeof __propDef.props;
export type WebhookOffEvents = typeof __propDef.events;
export type WebhookOffSlots = typeof __propDef.slots;
/**
 * @component @name WebhookOff
 * @description Lucide SVG icon component, renders SVG Element with children.
 *
 * @preview ![img](data:image/svg+xml;base64,PHN2ZyAgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIgogIHdpZHRoPSIyNCIKICBoZWlnaHQ9IjI0IgogIHZpZXdCb3g9IjAgMCAyNCAyNCIKICBmaWxsPSJub25lIgogIHN0cm9rZT0iIzAwMCIgc3R5bGU9ImJhY2tncm91bmQtY29sb3I6ICNmZmY7IGJvcmRlci1yYWRpdXM6IDJweCIKICBzdHJva2Utd2lkdGg9IjIiCiAgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIgogIHN0cm9rZS1saW5lam9pbj0icm91bmQiCj4KICA8cGF0aCBkPSJNMTcgMTdoLTVjLTEuMDktLjAyLTEuOTQuOTItMi41IDEuOUEzIDMgMCAxIDEgMi41NyAxNSIgLz4KICA8cGF0aCBkPSJNOSAzLjRhNCA0IDAgMCAxIDYuNTIuNjYiIC8+CiAgPHBhdGggZD0ibTYgMTcgMy4xLTUuOGEyLjUgMi41IDAgMCAwIC4wNTctMi4wNSIgLz4KICA8cGF0aCBkPSJNMjAuMyAyMC4zYTQgNCAwIDAgMS0yLjMuNyIgLz4KICA8cGF0aCBkPSJNMTguNiAxM2E0IDQgMCAwIDEgMy4zNTcgMy40MTQiIC8+CiAgPHBhdGggZD0ibTEyIDYgLjYgMSIgLz4KICA8cGF0aCBkPSJtMiAyIDIwIDIwIiAvPgo8L3N2Zz4K) - https://lucide.dev/icons/webhook-off
 * @see https://lucide.dev/guide/packages/lucide-svelte - Documentation
 *
 * @param {Object} props - Lucide icons props and any valid SVG attribute
 * @returns {FunctionalComponent} Svelte component
 *
 */
export default class WebhookOff extends SvelteComponentTyped<WebhookOffProps, WebhookOffEvents, WebhookOffSlots> {
}
export {};
