/**
 * @license lucide-svelte v0.469.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
import { SvelteComponentTyped } from "svelte";
import type { IconProps } from '../types.js';
declare const __propDef: {
    props: IconProps;
    events: {
        [evt: string]: CustomEvent<any>;
    };
    slots: {
        default: {};
    };
};
export type WheatOffProps = typeof __propDef.props;
export type WheatOffEvents = typeof __propDef.events;
export type WheatOffSlots = typeof __propDef.slots;
/**
 * @component @name WheatOff
 * @description Lucide SVG icon component, renders SVG Element with children.
 *
 * @preview ![img](data:image/svg+xml;base64,PHN2ZyAgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIgogIHdpZHRoPSIyNCIKICBoZWlnaHQ9IjI0IgogIHZpZXdCb3g9IjAgMCAyNCAyNCIKICBmaWxsPSJub25lIgogIHN0cm9rZT0iIzAwMCIgc3R5bGU9ImJhY2tncm91bmQtY29sb3I6ICNmZmY7IGJvcmRlci1yYWRpdXM6IDJweCIKICBzdHJva2Utd2lkdGg9IjIiCiAgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIgogIHN0cm9rZS1saW5lam9pbj0icm91bmQiCj4KICA8cGF0aCBkPSJtMiAyMiAxMC0xMCIgLz4KICA8cGF0aCBkPSJtMTYgOC0xLjE3IDEuMTciIC8+CiAgPHBhdGggZD0iTTMuNDcgMTIuNTMgNSAxMWwxLjUzIDEuNTNhMy41IDMuNSAwIDAgMSAwIDQuOTRMNSAxOWwtMS41My0xLjUzYTMuNSAzLjUgMCAwIDEgMC00Ljk0WiIgLz4KICA8cGF0aCBkPSJtOCA4LS41My41M2EzLjUgMy41IDAgMCAwIDAgNC45NEw5IDE1bDEuNTMtMS41M2MuNTUtLjU1Ljg4LTEuMjUuOTgtMS45NyIgLz4KICA8cGF0aCBkPSJNMTAuOTEgNS4yNmMuMTUtLjI2LjM0LS41MS41Ni0uNzNMMTMgM2wxLjUzIDEuNTNhMy41IDMuNSAwIDAgMSAuMjggNC42MiIgLz4KICA8cGF0aCBkPSJNMjAgMmgydjJhNCA0IDAgMCAxLTQgNGgtMlY2YTQgNCAwIDAgMSA0LTRaIiAvPgogIDxwYXRoIGQ9Ik0xMS40NyAxNy40NyAxMyAxOWwtMS41MyAxLjUzYTMuNSAzLjUgMCAwIDEtNC45NCAwTDUgMTlsMS41My0xLjUzYTMuNSAzLjUgMCAwIDEgNC45NCAwWiIgLz4KICA8cGF0aCBkPSJtMTYgMTYtLjUzLjUzYTMuNSAzLjUgMCAwIDEtNC45NCAwTDkgMTVsMS41My0xLjUzYTMuNDkgMy40OSAwIDAgMSAxLjk3LS45OCIgLz4KICA8cGF0aCBkPSJNMTguNzQgMTMuMDljLjI2LS4xNS41MS0uMzQuNzMtLjU2TDIxIDExbC0xLjUzLTEuNTNhMy41IDMuNSAwIDAgMC00LjYyLS4yOCIgLz4KICA8bGluZSB4MT0iMiIgeDI9IjIyIiB5MT0iMiIgeTI9IjIyIiAvPgo8L3N2Zz4K) - https://lucide.dev/icons/wheat-off
 * @see https://lucide.dev/guide/packages/lucide-svelte - Documentation
 *
 * @param {Object} props - Lucide icons props and any valid SVG attribute
 * @returns {FunctionalComponent} Svelte component
 *
 */
export default class WheatOff extends SvelteComponentTyped<WheatOffProps, WheatOffEvents, WheatOffSlots> {
}
export {};
