/**
 * @license lucide-svelte v0.469.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
import { SvelteComponentTyped } from "svelte";
import type { IconProps } from '../types.js';
declare const __propDef: {
    props: IconProps;
    events: {
        [evt: string]: CustomEvent<any>;
    };
    slots: {
        default: {};
    };
};
export type WheatProps = typeof __propDef.props;
export type WheatEvents = typeof __propDef.events;
export type WheatSlots = typeof __propDef.slots;
/**
 * @component @name Wheat
 * @description Lucide SVG icon component, renders SVG Element with children.
 *
 * @preview ![img](data:image/svg+xml;base64,PHN2ZyAgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIgogIHdpZHRoPSIyNCIKICBoZWlnaHQ9IjI0IgogIHZpZXdCb3g9IjAgMCAyNCAyNCIKICBmaWxsPSJub25lIgogIHN0cm9rZT0iIzAwMCIgc3R5bGU9ImJhY2tncm91bmQtY29sb3I6ICNmZmY7IGJvcmRlci1yYWRpdXM6IDJweCIKICBzdHJva2Utd2lkdGg9IjIiCiAgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIgogIHN0cm9rZS1saW5lam9pbj0icm91bmQiCj4KICA8cGF0aCBkPSJNMiAyMiAxNiA4IiAvPgogIDxwYXRoIGQ9Ik0zLjQ3IDEyLjUzIDUgMTFsMS41MyAxLjUzYTMuNSAzLjUgMCAwIDEgMCA0Ljk0TDUgMTlsLTEuNTMtMS41M2EzLjUgMy41IDAgMCAxIDAtNC45NFoiIC8+CiAgPHBhdGggZD0iTTcuNDcgOC41MyA5IDdsMS41MyAxLjUzYTMuNSAzLjUgMCAwIDEgMCA0Ljk0TDkgMTVsLTEuNTMtMS41M2EzLjUgMy41IDAgMCAxIDAtNC45NFoiIC8+CiAgPHBhdGggZD0iTTExLjQ3IDQuNTMgMTMgM2wxLjUzIDEuNTNhMy41IDMuNSAwIDAgMSAwIDQuOTRMMTMgMTFsLTEuNTMtMS41M2EzLjUgMy41IDAgMCAxIDAtNC45NFoiIC8+CiAgPHBhdGggZD0iTTIwIDJoMnYyYTQgNCAwIDAgMS00IDRoLTJWNmE0IDQgMCAwIDEgNC00WiIgLz4KICA8cGF0aCBkPSJNMTEuNDcgMTcuNDcgMTMgMTlsLTEuNTMgMS41M2EzLjUgMy41IDAgMCAxLTQuOTQgMEw1IDE5bDEuNTMtMS41M2EzLjUgMy41IDAgMCAxIDQuOTQgMFoiIC8+CiAgPHBhdGggZD0iTTE1LjQ3IDEzLjQ3IDE3IDE1bC0xLjUzIDEuNTNhMy41IDMuNSAwIDAgMS00Ljk0IDBMOSAxNWwxLjUzLTEuNTNhMy41IDMuNSAwIDAgMSA0Ljk0IDBaIiAvPgogIDxwYXRoIGQ9Ik0xOS40NyA5LjQ3IDIxIDExbC0xLjUzIDEuNTNhMy41IDMuNSAwIDAgMS00Ljk0IDBMMTMgMTFsMS41My0xLjUzYTMuNSAzLjUgMCAwIDEgNC45NCAwWiIgLz4KPC9zdmc+Cg==) - https://lucide.dev/icons/wheat
 * @see https://lucide.dev/guide/packages/lucide-svelte - Documentation
 *
 * @param {Object} props - Lucide icons props and any valid SVG attribute
 * @returns {FunctionalComponent} Svelte component
 *
 */
export default class Wheat extends SvelteComponentTyped<WheatProps, WheatEvents, WheatSlots> {
}
export {};
