"use strict";
var __assign = Object.assign;
Object.defineProperty(exports, "__esModule", {value: true});
var path = require("path");
var compiler = require("svelte/compiler");
var svelteHmr = require("svelte-hmr");
var rollupSveltePlugin = require("rollup-plugin-svelte");
function _interopDefaultLegacy(e) {
  return e && typeof e === "object" && "default" in e ? e : {default: e};
}
var rollupSveltePlugin__default = /* @__PURE__ */ _interopDefaultLegacy(rollupSveltePlugin);
function componentize(str) {
  return path.basename(str[0].toUpperCase() + str.slice(1)).replace(path.extname(str), "").replace(/[^a-zA-Z_$0-9]+/g, "_").replace(/^_/, "").replace(/_$/, "").replace(/^(\d)/, "_$1");
}
function push(arr, items) {
  for (let item of items) {
    if (!arr.includes(item))
      arr.push(item);
  }
  return arr;
}
let hotApiPath = path.dirname(require.resolve("svelte-hmr/runtime"));
let RE_SVELTE_EXT = /\.svelte$/i;
function svelte(opts = {}) {
  let {
    compilerOptions,
    preprocess: preprocessOpts,
    hmrOptions = {},
    pluginOptions = {}
  } = opts;
  let {
    resolveSvelteField = true,
    hotApiMount = "/@@svelte-hmr"
  } = pluginOptions;
  hotApiMount = path.join(hotApiMount, "/");
  let makeHot = hmrOptions && svelteHmr.createMakeHot({
    walk: compiler.walk,
    hotApi: path.join(hotApiMount, "hot-api-esm.js"),
    adapter: path.join(hotApiMount, "proxy-adapter-dom.js")
  });
  if (resolveSvelteField) {
    try {
      let {mainFields} = require("vite/dist/node/resolver");
      mainFields.unshift("svelte");
    } catch (e) {
    }
  }
  return {
    rollupInputOptions: {
      plugins: [
        rollupSveltePlugin__default["default"](__assign(__assign({
          dev: false
        }, compilerOptions), {
          preprocess: preprocessOpts,
          include: RE_SVELTE_EXT,
          format: "esm",
          generate: "dom",
          emitCss: true
        }))
      ]
    },
    configureServer: [({config}) => {
      let prevOptimizeDeps = config.optimizeDeps || {};
      config.optimizeDeps = __assign(__assign({}, prevOptimizeDeps), {
        include: prevOptimizeDeps.include || [],
        exclude: prevOptimizeDeps.exclude || []
      });
      push(config.optimizeDeps.include, [
        "svelte",
        "svelte/internal",
        "svelte/store",
        "svelte/animate",
        "svelte/easing",
        "svelte/motion",
        "svelte/transition"
      ]);
    }],
    alias: {
      [hotApiMount]: hotApiPath
    },
    transforms: [{
      test: (ctx) => !ctx.isBuild && RE_SVELTE_EXT.test(ctx.path),
      transform: async ({path: filename, code}) => {
        if (preprocessOpts) {
          let result2 = await compiler.preprocess(code, preprocessOpts, {filename});
          code = result2.code;
        }
        let compiled = compiler.compile(code, __assign(__assign({
          dev: true
        }, compilerOptions), {
          filename,
          name: componentize(filename),
          format: "esm",
          generate: "dom"
        }));
        let result = compiled.js.code;
        if (hmrOptions) {
          result = makeHot(filename, result, __assign(__assign({}, hmrOptions), {
            compatVite: true
          }), compiled, code, true);
        }
        return {code: result};
      }
    }]
  };
}
exports.svelte = svelte;
