import { createRequire } from 'module';
const require = createRequire(import.meta.url);
const { PrismaClient } = require('@prisma/client');
import bcrypt from 'bcrypt';

const prisma = new PrismaClient();

async function main() {
    // Create or update sample brands with logos
    const vw = await prisma.brand.upsert({
        where: { name: 'Volkswagen' },
        update: {},
        create: { name: 'Volkswagen', imageUrl: '/images/logos/brands/vw.png' },
    });

    const audi = await prisma.brand.upsert({
        where: { name: 'Audi' },
        update: {},
        create: { name: 'Audi', imageUrl: '/images/logos/brands/audi.png' },
    });

    const skoda = await prisma.brand.upsert({
        where: { name: 'Skoda' },
        update: {},
        create: { name: 'Skoda', imageUrl: '/images/logos/brands/skoda.png' },
    });

    const seat = await prisma.brand.upsert({
        where: { name: 'Seat' },
        update: {},
        create: { name: 'Seat', imageUrl: '/images/logos/brands/seat.png' },
    });

    // Create or update sample forms with initial questions
    const existingForm1 = await prisma.form.findFirst({
        where: { department: 'sales' },
    });

    if (!existingForm1) {
        await prisma.form.create({
            data: {
                department: 'sales',
                brands: {
                    connect: [{ id: vw.id }, { id: skoda.id }, { id: audi.id }, { id: seat.id }], 
                },
                questions: {
                    create: [
                        {
                            text: 'How would you rate our service?',
                            order: 1,
                            type: 'rating',
                        },
                        {
                            text: 'What can we improve?',
                            order: 2,
                            type: 'comment',
                        },
                    ],
                },
                isActive: true, // Set the form to active
            },
        });
    }

    const existingForm2 = await prisma.form.findFirst({
        where: { department: 'service' },
    });

    if (!existingForm2) {
        await prisma.form.create({
            data: {
                department: 'service',
                brands: {
                    connect: [{ id: vw.id }, { id: skoda.id }, { id: audi.id }, { id: seat.id }],
                },
                questions: {
                    create: [
                        {
                            text: 'How would you rate our product?',
                            order: 1,
                            type: 'rating',
                        },
                        {
                            text: 'Any additional feedback?',
                            order: 2,
                            type: 'comment',
                        },
                    ],
                },
                isActive: true, // Set the form to active
            },
        });
    }

    // Create or update sample clients
    const client1 = await prisma.client.upsert({
        where: { username: 'client1' },
        update: {},
        create: {
            username: 'client1',
            totalPoints: 10,
            totalRounds: 5,
            themePreference: 'dark',
        },
    });

    const client2 = await prisma.client.upsert({
        where: { username: 'client2' },
        update: {},
        create: {
            username: 'client2',
            totalPoints: 20,
            totalRounds: 10,
            themePreference: 'light',
        },
    });

    // Create or update sample admins
    const admin1 = await prisma.admin.upsert({
        where: { username: 'admin1' },
        update: {},
        create: {
            username: 'admin1',
            password: await bcrypt.hash('password', 10), // Ensure to hash passwords in real applications
            email: 'admin1@example.com',
            role: 'SUPER_ADMIN',
            privileges: "MODIFY_FORM,CHECK_RESPONSES,DOWNLOAD_RESPONSES,MANAGE_ADMINS"
        },
    });

    const admin2 = await prisma.admin.upsert({
        where: { username: 'admin2' },
        update: {},
        create: {
            username: 'admin2',
            password: await bcrypt.hash('password1', 10), // Ensure to hash passwords in real applications
            email: 'admin2@example.com',
            role: 'ADMIN',
            privileges: "MODIFY_FORM,CHECK_RESPONSES,DOWNLOAD_RESPONSES"
        },
    });

    // Create mock responses
    const response1 = await prisma.response.create({
        data: {
            questionId: (await prisma.question.findFirst({ where: { text: 'How would you rate our service?' } })).id,
            clientId: client1.id,
            brandId: vw.id,
            value: '5', // Example rating
        },
    });

    const response2 = await prisma.response.create({
        data: {
            questionId: (await prisma.question.findFirst({ where: { text: 'What can we improve?' } })).id,
            clientId: client1.id,
            brandId: vw.id,
            value: 'More variety in products.', // Example comment
        },
    });

    const response3 = await prisma.response.create({
        data: {
            questionId: (await prisma.question.findFirst({ where: { text: 'How would you rate our product?' } })).id,
            clientId: client2.id,
            brandId: audi.id,
            value: '4', // Example rating
        },
    });

    const response4 = await prisma.response.create({
        data: {
            questionId: (await prisma.question.findFirst({ where: { text: 'Any additional feedback?' } })).id,
            clientId: client2.id,
            brandId: audi.id,
            value: 'Great product, keep it up!', // Example comment
        },
    });

    console.log('Seeding completed:', { vw, skoda, audi, seat, client1, client2, admin1, admin2, response1, response2, response3, response4 });
}

main()
    .catch((e) => {
        console.error(e);
        process.exit(1);
    })
    .finally(async () => {
        await prisma.$disconnect();
    });