import { writable } from 'svelte/store';

// Initialize the score from localStorage or default to 0
const storedScore = typeof localStorage !== 'undefined' ? localStorage.getItem('totalScore') : '0';
const initialScore = parseInt(storedScore) || 0;

// Create the score store
const score = writable(initialScore);

// Subscribe to changes and update localStorage
if (typeof window !== 'undefined') {
    score.subscribe(value => {
        localStorage.setItem('totalScore', value.toString());
    });
}

// Helper function to add points
function addPoints(points) {
    score.update(current => Math.max(0, current + points));
}

export { score, addPoints };
