import { writable } from 'svelte/store';

let isAdmin;

const createSessionStore = () => {
    const { subscribe, set } = writable({ user: null, isAdmin: false });

    return {
        subscribe,
        startSession: (user) => {
            try {
                isAdmin = user.role ? user.role === 'ADMIN' || user.role === 'SUPER_ADMIN' : false;
                set({ user, isAdmin });
                // Store in local storage for persistence
                localStorage.setItem('user', JSON.stringify(user));
            } catch (error) {
                console.error('Error starting session:', error);
            }
        },
        endSession: () => {
            try {
                set({ user: null, isAdmin: false });
                // Clear local storage
                localStorage.removeItem('user');
            } catch (error) {
                console.error('Error ending session:', error);
            }
        },
        checkAuth: () => {
            try {
                const storedUser = localStorage.getItem('user');
                console.log("STORED USER: " + storedUser);
                if (storedUser) {
                    const user = JSON.parse(storedUser);
                    isAdmin = user.role ? user.role === 'ADMIN' || user.role === 'SUPER_ADMIN' : false;
                    set({ user, isAdmin });
                    return true;
                }
                return false;
            } catch (error) {
                console.error('Error checking authentication:', error);
                return false; // Return false if there's an error
            }
        },
    };
};

export const sessionManager = createSessionStore(); // Ensure this is the correct export