// theme.js

// Example: Exporting a default theme object
import { writable } from 'svelte/store';

// Create a proper Svelte store for theme
function createThemeStore() {
    // Get initial theme from localStorage or default to 'light'
    const storedTheme = typeof localStorage !== 'undefined' ? localStorage.getItem('theme') : 'light';
    const initialTheme = storedTheme || 'light';
    
    const { subscribe, set, update } = writable(initialTheme);

    return {
        subscribe,
        set: (value) => {
            if (typeof localStorage !== 'undefined') {
                localStorage.setItem('theme', value);
            }
            set(value);
        },
        toggle: () => update(theme => {
            const newTheme = theme === 'light' ? 'dark' : 'light';
            if (typeof localStorage !== 'undefined') {
                localStorage.setItem('theme', newTheme);
            }
            return newTheme;
        }),
    };
}

export const theme = createThemeStore();

// You can expand this file with more theme-related logic or data as needed.
