import { json } from '@sveltejs/kit';
import { createRequire } from 'module';
const require = createRequire(import.meta.url);
const { PrismaClient } = require('@prisma/client');
import bcrypt from 'bcrypt';

const prisma = new PrismaClient();

export const GET = async () => {
    const admins = await prisma.admin.findMany();
    return json(admins);
};


export const POST = async ({ request }) => {
    const { username, password, phoneNumber, email, role, privileges } = await request.json();
    
    // Hash the password with bcrypt
    const hashedPassword = await bcrypt.hash(password, 10);

    const newAdmin = await prisma.admin.create({
        data: {
            username,
            password: hashedPassword, // Store the hashed password
            phoneNumber,
            email,
            role,
            privileges,
        },
    });

    return json(newAdmin, { status: 201 });
};
