import { json } from '@sveltejs/kit';
import { createRequire } from 'module';
const require = createRequire(import.meta.url);
const { PrismaClient } = require('@prisma/client');
import bcrypt from 'bcrypt';
import jwt from 'jsonwebtoken';

const prisma = new PrismaClient();

export const POST = async ({ request }) => {
    try {
        const { login, password } = await request.json();
        console.log(`Admin login attempt: ${JSON.stringify({ login, password })}`);

        const admin = await prisma.admin.findFirst({
            where: {
                OR: [
                    { username: login },
                    { email: login },
                ],
            },
        });

        if (!admin) {
            return json({ message: 'Invalid login information' }, { status: 401 });
        }

        // Verify password
        if (!await verifyPassword(password, admin.password)) {
            return json({ message: 'Invalid login information' }, { status: 401 });
        }

        // Generate a JWT token
        const token = jwt.sign({
            id: admin.id,
            username: admin.username,
            email: admin.email,
            role: admin.role,
        }, process.env.JWT_SECRET, {
            expiresIn: '2h'
        });

        // Return the JWT token to the frontend to start a session
        return json({
            message: 'Login successful',
            token, // Return the JWT token
            user: {
                id: admin.id,
                username: admin.username,
                email: admin.email,
                role: admin.role,
            }
        });
    } catch (error) {
        console.error('Error during admin login:', error);
        return json({ message: 'Internal server error' }, { status: 500 });
    }
};

// Password verification function
const verifyPassword = async (password, hash) => {
    return await bcrypt.compare(password, hash);
};