import { createRequire } from 'module';
const require = createRequire(import.meta.url);
const { PrismaClient } = require('@prisma/client');
import { json } from '@sveltejs/kit';

const prisma = new PrismaClient();

export async function GET() {
    try {
        const brands = await prisma.brand.findMany({
            where: {
                isActive: true, // Only fetch active brands
            },
        });
        return new Response(JSON.stringify(brands), {
            status: 200,
            headers: {
                'Content-Type': 'application/json',
            },
        });
    } catch (error) {
        console.error('Error fetching brands:', error);
        return new Response('Error fetching brands', { status: 500 });
    } finally {
        await prisma.$disconnect();
    }
}

export const POST = async ({ request }) => {
    const { name, imageUrl } = await request.json();

    try {
        const brand = await prisma.brand.create({
            data: {
                name,
                imageUrl
            }
        });

        return json(brand, { status: 201 });
    } catch (error) {
        console.error('Error creating brand:', error);
        return json({ error: 'Failed to create brand' }, { status: 500 });
    }
};