import { json } from '@sveltejs/kit';
import { createRequire } from 'module';
const require = createRequire(import.meta.url);
const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

export const GET = async () => {
    const clients = await prisma.client.findMany();
    return json(clients);
};

export const POST = async ({ request }) => {
    const { username, totalPoints, totalRounds, themePreference } = await request.json();
    const newClient = await prisma.client.create({
        data: {
            username,
            totalPoints,
            totalRounds,
            themePreference,
        },
    });
    return json(newClient, { status: 201 });
};