import { json } from '@sveltejs/kit';
import { createRequire } from 'module';
const require = createRequire(import.meta.url);
const { PrismaClient } = require('@prisma/client');
import { sessionManager } from '$lib/stores/sessionStore'; // Import the session manager

const prisma = new PrismaClient();

export const POST = async ({ request }) => {
    const { username } = await request.json(); // Get the username from the request body

    // Check if the client exists
    let client = await prisma.client.findUnique({
        where: { username },
    });

    if (client) {
        // If client exists, start the session
        sessionManager.startSession(client);
        return json(client); // Return the existing client data
    } else {
        // If client does not exist, create a new client
        client = await prisma.client.create({
            data: {
                username,
                totalPoints: 0, // Default values
                totalRounds: 0,
                themePreference: 'dark', // Default preference
            },
        });
        // Start session for the new client
        sessionManager.startSession(client);
        return json(client); // Return the new client data
    }
};