// src/routes/api/questions/+server.js
import { json } from '@sveltejs/kit';
import { createRequire } from 'module';
const require = createRequire(import.meta.url);
const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

export const GET = async ({ url }) => {
    const formId = url.searchParams.get('formId'); // Get the form ID

    try {
        const questions = await prisma.question.findMany({
            where: {
                formId: formId, // Filter by form ID
            },
        });
        return json(questions);
    } catch (error) {
        console.error('Error fetching questions:', error);
        return json({ message: 'Error fetching questions' }, { status: 500 });
    }
};

export const POST = async ({ request }) => {
    const { type, text, formId, order } = await request.json();

    try {
        const createdQuestion = await prisma.question.create({
            data: {
                type,
                text,
                formId,
                order
            },
        });
        return json(createdQuestion, { status: 201 });
    } catch (error) {
        console.error('Error creating question:', error);
        return json({ message: 'Error creating question', error: error.message }, { status: 500 });
    }
};

export const PATCH = async ({ request }) => {
    const { questions } = await request.json();

    try {
        const updatedQuestions = await prisma.question.updateMany({
            data: questions,
            where: {
                id: { in: questions.map(q => q.id) },
            },
        });
        return json(updatedQuestions, { status: 200 });
    } catch (error) {
        console.error('Error updating questions order:', error);
        return json({ message: 'Error updating questions order', error: error.message }, { status: 500 });
    }
};
