import { createRequire } from 'module';
const require = createRequire(import.meta.url);
const { PrismaClient } = require('@prisma/client');
import { json } from '@sveltejs/kit';

const prisma = new PrismaClient();

export const PATCH = async ({ request }) => {
    const questions = await request.json();

    try {
        const updatePromises = questions.map(question =>
            prisma.question.update({
                where: { id: question.id },
                data: { order: question.order },
            })
        );

        await Promise.all(updatePromises);

        return json({ message: 'Questions reordered successfully' });
    } catch (error) {
        console.error('Error reordering questions:', error);
        return json({ message: 'Could not reorder questions', error: error.message }, { status: 500 });
    }
};
