import { l as store_get, j as attr, k as stringify, i as ensure_array_like, e as escape_html, u as unsubscribe_stores, p as pop, b as push } from "./hooks.server.js";
import { s as sessionManager } from "./sessionStore.js";
import { F as Fa } from "./fa.js";
/* empty css                                             */
import { faStar, faCar, faWrench } from "@fortawesome/free-solid-svg-icons";
import { faStar as faStar$1 } from "@fortawesome/free-regular-svg-icons";
import { w as writable } from "./index3.js";
import "./index2.js";
import { T as Textarea } from "./textarea.js";
import "canvas-confetti";
/* empty css                                                */
const defaultState = {
  department: "",
  brand: "",
  currentStep: 1,
  questionIndex: 0,
  totalQuestions: [],
  completedQuestions: {},
  lastFeedbackDate: null,
  roundsPlayed: 0,
  isComplete: false,
  progress: 0,
  currentRoundStarted: false,
  currentRound: 1,
  answers: {}
};
const initialState = {
  roundsPlayed: 0,
  isComplete: false,
  progress: 0,
  currentRoundStarted: false,
  currentRound: 1,
  answers: {},
  feedbackShownForRounds: {},
  // Track which rounds we've shown feedback for
  lastFeedbackDate: null
  // Track when feedback was last shown
};
const createFeedbackStore = () => {
  const initialStateWithStorage = initialState;
  const { subscribe, set, update } = writable({ ...defaultState, ...initialStateWithStorage });
  return {
    subscribe,
    updateState: (newState) => update((state) => {
      const updatedState = { ...state, ...newState };
      return updatedState;
    }),
    startNewRound: () => {
      update((state) => {
        const updatedState = {
          ...state,
          currentRoundStarted: true
        };
        return updatedState;
      });
    },
    completeRound: () => {
      update((state) => {
        const updatedState = {
          ...state,
          roundsPlayed: state.roundsPlayed + 1,
          currentRoundStarted: false,
          currentRound: state.currentRound + 1,
          lastFeedbackDate: (/* @__PURE__ */ new Date()).toISOString()
          // Update last feedback date
        };
        return updatedState;
      });
    },
    completeQuestion: (question, answer) => {
      update((state) => {
        const newCompletedQuestions = { ...state.completedQuestions, [question]: answer };
        const totalAnswered = Object.keys(newCompletedQuestions).length;
        const totalQuestions = state.totalQuestions.length + 2;
        const progress = Math.round(totalAnswered / totalQuestions * 100);
        const updatedState = {
          ...state,
          completedQuestions: newCompletedQuestions,
          progress,
          questionIndex: state.questionIndex + (question === "department" || question === "brand" ? 0 : 1),
          isComplete: totalAnswered === totalQuestions,
          answers: { ...state.answers, [question]: answer }
        };
        return updatedState;
      });
    },
    setTotalQuestions: (questions) => {
      update((state) => {
        const updatedState = { ...state, totalQuestions: questions };
        return updatedState;
      });
    },
    reset: () => {
      const newState = { ...defaultState, ...initialState };
      set(newState);
    },
    shouldShowFeedback: () => {
      let shouldShow = false;
      update((state) => {
        if (!state.lastFeedbackDate) {
          shouldShow = true;
          return state;
        }
        const lastDate = new Date(state.lastFeedbackDate);
        const today = /* @__PURE__ */ new Date();
        shouldShow = lastDate.getDate() !== today.getDate() || lastDate.getMonth() !== today.getMonth() || lastDate.getFullYear() !== today.getFullYear();
        return state;
      });
      return shouldShow;
    },
    getCurrentQuestions: () => {
      let currentQuestions = [];
      update((state) => {
        if (state.totalQuestions.length > 0) {
          const startIdx = state.questionIndex;
          const endIdx = Math.min(startIdx + 2, state.totalQuestions.length);
          currentQuestions = state.totalQuestions.slice(startIdx, endIdx).filter((q) => !state.completedQuestions[q]);
        }
        return state;
      });
      return currentQuestions;
    },
    getProgress: () => {
      let progress = 0;
      update((state) => {
        const totalAnswered = Object.keys(state.completedQuestions).length;
        const totalQuestions = state.totalQuestions.length + 2;
        progress = Math.round(totalAnswered / totalQuestions * 100);
        return state;
      });
      return progress;
    },
    getCurrentRound: () => {
      let currentState;
      subscribe((store) => {
        currentState = store;
      })();
      return currentState.currentRound;
    },
    setRound: (round) => update((store) => {
      store.currentRound = round;
      console.log("🔄 Feedback Store: Round set to", store.currentRound);
      return store;
    }),
    saveAnswer: (questionId, answer) => update((store) => {
      store.answers[questionId] = answer;
      return store;
    }),
    incrementRound: () => {
      update((state) => {
        const newState = {
          ...state,
          currentRound: state.currentRound + 1,
          roundsPlayed: state.roundsPlayed + 1
        };
        console.log("🔄 Feedback Store: Incrementing round", {
          oldRound: state.currentRound,
          newRound: newState.currentRound
        });
        return newState;
      });
    },
    markFeedbackShown: (round) => {
      update((state) => {
        const newState = {
          ...state,
          feedbackShownForRounds: {
            ...state.feedbackShownForRounds,
            [round]: true
          }
        };
        console.log("📝 Feedback Store: Marked feedback shown for round", round);
        return newState;
      });
    },
    isFeedbackShown: (round) => {
      let currentState;
      subscribe((store) => {
        currentState = store;
      })();
      return !!currentState.feedbackShownForRounds[round];
    }
  };
};
const feedbackStore = createFeedbackStore();
function GameFeedbackModal($$payload, $$props) {
  push();
  var $$store_subs;
  let questions = [];
  let answers = {};
  let progress = 0;
  let selectedBrand = "";
  let brands = [];
  let currentQuestionPair = [];
  let isLoading = true;
  let feedbackShownToday = false;
  let currentRound = store_get($$store_subs ??= {}, "$feedbackStore", feedbackStore).currentRound;
  let isFirstOddRoundToday = false;
  let isVisible = false;
  sessionManager.subscribe((value) => {
    value.user;
  });
  function isToday(date) {
    const today = /* @__PURE__ */ new Date();
    return date.getDate() === today.getDate() && date.getMonth() === today.getMonth() && date.getFullYear() === today.getFullYear();
  }
  function checkFirstOddRoundStatus() {
    const lastSetupDate = localStorage.getItem("feedbackSetupDate");
    if (!lastSetupDate) {
      isFirstOddRoundToday = true;
      return;
    }
    const setupDate = new Date(lastSetupDate);
    isFirstOddRoundToday = !isToday(setupDate);
  }
  {
    currentRound = store_get($$store_subs ??= {}, "$feedbackStore", feedbackStore).currentRound;
    if (currentRound % 2 === 1 && !feedbackShownToday) {
      checkFirstOddRoundStatus();
    }
  }
  {
    const shouldShow = currentRound % 2 === 1 && !feedbackShownToday && !isLoading;
    if (shouldShow !== isVisible) {
      isVisible = shouldShow;
      console.log("📝 Modal visibility updated:", {
        isVisible,
        currentRound,
        feedbackShownToday,
        isLoading
      });
    }
  }
  {
    const totalItems = questions.length + 2;
    const answeredCount = Object.keys(answers).length;
    progress = answeredCount / totalItems * 100;
  }
  if (isVisible) {
    $$payload.out += "<!--[-->";
    $$payload.out += `<div class="fixed inset-0 z-40 overflow-hidden"><div class="absolute inset-0 bg-black/50 backdrop-blur-sm"></div> <div class="absolute inset-0 overflow-y-auto"><div class="flex min-h-full items-center justify-center p-4"><div class="relative w-full max-w-xl rounded-xl bg-white dark:bg-zinc-900 shadow-lg"><div class="p-6"><div class="space-y-6"><div><h2 class="text-2xl font-bold text-center">Feedback</h2> <p class="text-center text-zinc-600 dark:text-zinc-400 mt-2">Ju lutemi të jepni përgjigjet tuaja në këtë form.</p> <div class="w-full bg-gray-300 dark:bg-zinc-800 rounded-full h-2.5 mt-4"><div class="bg-primary h-2.5 rounded-full transition-all duration-500"${attr("style", `width: ${stringify(progress)}%`)}></div></div></div> <div class="space-y-6">`;
    if (isFirstOddRoundToday) {
      $$payload.out += "<!--[-->";
      const each_array = ensure_array_like(brands);
      $$payload.out += `<div class="space-y-4"><h3 class="text-lg font-semibold text-center">Cfarë shërbimi po prisni?</h3> <div class="grid grid-cols-2 gap-4"><button type="button"${attr("class", `flex flex-col items-center gap-3 p-4 rounded-xl border-2 transition-colors ${stringify("border-zinc-800 hover:border-orange-500/50")}`)}>`;
      Fa($$payload, { icon: faCar, class: "text-3xl" });
      $$payload.out += `<!----> <span class="font-medium">Shitje</span></button> <button type="button"${attr("class", `flex flex-col items-center gap-3 p-4 rounded-xl border-2 transition-colors ${stringify("border-zinc-800 hover:border-orange-500/50")}`)}>`;
      Fa($$payload, { icon: faWrench, class: "text-3xl" });
      $$payload.out += `<!----> <span class="font-medium">Servis</span></button></div></div> <div class="space-y-4"><h3 class="text-lg font-semibold text-center">Zgjidhni markën tuaj</h3> <div class="grid grid-cols-2 gap-4"><!--[-->`;
      for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
        let brand = each_array[$$index];
        $$payload.out += `<button type="button"${attr("class", `flex flex-col items-center p-4 rounded-xl border-2 transition-colors ${stringify(selectedBrand === brand.id ? "border-orange-500 bg-orange-500/10" : "border-zinc-800 hover:border-orange-500/50")}`)}><img${attr("src", brand.imageUrl)}${attr("alt", brand.name)} class="w-20 h-20 dark:invert"> <span class="font-medium">${escape_html(brand.name)}</span></button>`;
      }
      $$payload.out += `<!--]--></div></div>`;
    } else {
      $$payload.out += "<!--[!-->";
      if (currentQuestionPair.length > 0) {
        $$payload.out += "<!--[-->";
        const each_array_1 = ensure_array_like(currentQuestionPair);
        $$payload.out += `<!--[-->`;
        for (let $$index_2 = 0, $$length = each_array_1.length; $$index_2 < $$length; $$index_2++) {
          let question = each_array_1[$$index_2];
          if (question.type === "rating") {
            $$payload.out += "<!--[-->";
            const each_array_2 = ensure_array_like(Array(5));
            $$payload.out += `<div class="space-y-2"><p class="font-medium text-center">${escape_html(question.text)}</p> <div class="flex gap-2 justify-center"><!--[-->`;
            for (let i = 0, $$length2 = each_array_2.length; i < $$length2; i++) {
              each_array_2[i];
              $$payload.out += `<button type="button" class="text-2xl transition-colors">`;
              Fa($$payload, {
                icon: answers[question.id] > i ? faStar : faStar$1,
                class: answers[question.id] > i ? "text-orange-500" : "text-zinc-600"
              });
              $$payload.out += `<!----></button>`;
            }
            $$payload.out += `<!--]--></div></div>`;
          } else {
            $$payload.out += "<!--[!-->";
          }
          $$payload.out += `<!--]--> `;
          if (question.type === "comment") {
            $$payload.out += "<!--[-->";
            $$payload.out += `<div class="space-y-2"><div class="flex items-center gap-2"><p class="font-medium">${escape_html(question.text)}</p> `;
            if (question.required) {
              $$payload.out += "<!--[-->";
              $$payload.out += `<span class="text-orange-500 text-sm">*</span>`;
            } else {
              $$payload.out += "<!--[!-->";
            }
            $$payload.out += `<!--]--></div> `;
            Textarea($$payload, {
              placeholder: "Shkruani përgjigjen tuaj këtu...",
              rows: "3",
              class: "w-full resize-none",
              value: answers[question.id] || ""
            });
            $$payload.out += `<!----></div>`;
          } else {
            $$payload.out += "<!--[!-->";
          }
          $$payload.out += `<!--]-->`;
        }
        $$payload.out += `<!--]-->`;
      } else {
        $$payload.out += "<!--[!-->";
      }
      $$payload.out += `<!--]-->`;
    }
    $$payload.out += `<!--]--> `;
    {
      $$payload.out += "<!--[!-->";
    }
    $$payload.out += `<!--]--></div></div></div></div></div></div></div>`;
  } else {
    $$payload.out += "<!--[!-->";
  }
  $$payload.out += `<!--]-->`;
  if ($$store_subs) unsubscribe_stores($$store_subs);
  pop();
}
export {
  GameFeedbackModal as G,
  feedbackStore as f
};
