import { r as rest_props, d as spread_attributes, e as escape_html, f as bind_props, p as pop, h as sanitize_props, b as push } from "./hooks.server.js";
import { c as cn } from "./button.js";
import { f as fallback } from "./utils.js";
function Textarea($$payload, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, ["class", "value", "readonly"]);
  push();
  let className = fallback($$props["class"], void 0);
  let value = fallback($$props["value"], void 0);
  let readonly = fallback($$props["readonly"], void 0);
  $$payload.out += `<textarea${spread_attributes({
    class: cn("border-input placeholder:text-muted-foreground focus-visible:ring-ring flex min-h-[60px] w-full rounded-md border bg-transparent px-3 py-2 text-sm shadow-sm focus-visible:outline-none focus-visible:ring-1 disabled:cursor-not-allowed disabled:opacity-50", className),
    readonly,
    ...$$restProps
  })}>`;
  const $$body = escape_html(value);
  if ($$body) {
    $$payload.out += `${$$body}`;
  }
  $$payload.out += `</textarea>`;
  bind_props($$props, { class: className, value, readonly });
  pop();
}
export {
  Textarea as T
};
