import { j as json } from "../../../../../chunks/index.js";
import { PrismaClient } from "@prisma/client";
const prisma = new PrismaClient();
const GET = async ({ params }) => {
  const { id } = params;
  const client = await prisma.client.findUnique({
    where: { id }
  });
  if (!client) {
    return json({ message: "Client not found" }, { status: 404 });
  }
  return json(client);
};
const PATCH = async ({ params, request }) => {
  const { id } = params;
  const updates = await request.json();
  console.log("Incoming request for client ID:", id);
  console.log("Request body:", updates);
  try {
    const updatedClient = await prisma.client.update({
      where: { id },
      data: {
        ...updates,
        updatedAt: /* @__PURE__ */ new Date()
        // Update the timestamp if needed
      }
    });
    return json(updatedClient);
  } catch (error) {
    console.error("Error updating client:", error);
    return json({ message: "Client not found or could not be updated" }, { status: 404 });
  }
};
const PUT = async ({ params, request }) => {
  const { id } = params;
  const {
    username,
    totalPoints,
    totalRounds,
    lastPlayed,
    lastFeedback,
    lastFeedbackIP,
    themePreference
  } = await request.json();
  try {
    const updatedClient = await prisma.client.update({
      where: { id },
      data: {
        username,
        totalPoints,
        totalRounds,
        lastPlayed,
        lastFeedback,
        lastFeedbackIP,
        themePreference,
        updatedAt: /* @__PURE__ */ new Date()
        // Update the timestamp
      }
    });
    return json(updatedClient);
  } catch (error) {
    console.error("Error updating client:", error);
    return json({ message: "Client not found or could not be updated" }, { status: 404 });
  }
};
const DELETE = async ({ params }) => {
  const { id } = params;
  try {
    await prisma.client.delete({
      where: { id }
    });
    return json({ message: "Client deleted" });
  } catch (error) {
    console.error("Error deleting client:", error);
    return json({ message: "Client not found or could not be deleted" }, { status: 404 });
  }
};
export {
  DELETE,
  GET,
  PATCH,
  PUT
};
