import { j as json } from "../../../../../chunks/index.js";
import { PrismaClient } from "@prisma/client";
import { s as sessionManager } from "../../../../../chunks/sessionStore.js";
const prisma = new PrismaClient();
const POST = async ({ request }) => {
  const { username } = await request.json();
  let client = await prisma.client.findUnique({
    where: { username }
  });
  if (client) {
    sessionManager.startSession(client);
    return json(client);
  } else {
    client = await prisma.client.create({
      data: {
        username,
        totalPoints: 0,
        // Default values
        totalRounds: 0,
        themePreference: "dark"
        // Default preference
      }
    });
    sessionManager.startSession(client);
    return json(client);
  }
};
export {
  POST
};
