import { PrismaClient } from "@prisma/client";
import { j as json } from "../../../../../chunks/index.js";
const prisma = new PrismaClient();
const PATCH = async ({ request, params }) => {
  const { id } = params;
  const updatedQuestion = await request.json();
  try {
    const question = await prisma.question.update({
      where: { id },
      data: {
        ...updatedQuestion,
        updatedAt: /* @__PURE__ */ new Date()
      }
    });
    return json(question);
  } catch (error) {
    console.error("Error updating question:", error);
    return json({ message: "Question not found or could not be updated" }, { status: 404 });
  }
};
const DELETE = async ({ params }) => {
  const { id } = params;
  try {
    const question = await prisma.question.findUnique({
      where: { id }
    });
    if (!question) {
      return json({ message: `Question ${id} not found` }, { status: 404 });
    }
    await prisma.response.deleteMany({
      where: { questionId: id }
    });
    await prisma.question.delete({
      where: { id }
    });
    return json({ message: `Question ${id} deleted` });
  } catch (error) {
    console.error(`Error deleting question ${id}:`, error);
    return json({ message: `Question ${id} could not be deleted`, error: error.message }, { status: 500 });
  }
};
export {
  DELETE,
  PATCH
};
