import { j as json } from "../../../../chunks/index.js";
import { PrismaClient } from "@prisma/client";
const prisma = new PrismaClient();
const GET = async ({ url }) => {
  const formId = url.searchParams.get("formId");
  try {
    const questions = await prisma.question.findMany({
      where: {
        formId
        // Filter by form ID
      }
    });
    return json(questions);
  } catch (error) {
    console.error("Error fetching questions:", error);
    return json({ message: "Error fetching questions" }, { status: 500 });
  }
};
const POST = async ({ request }) => {
  const { type, text, formId, order } = await request.json();
  try {
    const createdQuestion = await prisma.question.create({
      data: {
        type,
        text,
        formId,
        order
      }
    });
    return json(createdQuestion, { status: 201 });
  } catch (error) {
    console.error("Error creating question:", error);
    return json({ message: "Error creating question", error: error.message }, { status: 500 });
  }
};
const PATCH = async ({ request }) => {
  const { questions } = await request.json();
  try {
    const updatedQuestions = await prisma.question.updateMany({
      data: questions,
      where: {
        id: { in: questions.map((q) => q.id) }
      }
    });
    return json(updatedQuestions, { status: 200 });
  } catch (error) {
    console.error("Error updating questions order:", error);
    return json({ message: "Error updating questions order", error: error.message }, { status: 500 });
  }
};
export {
  GET,
  PATCH,
  POST
};
