import { l as store_get, c as copy_payload, a as assign_payload, u as unsubscribe_stores, p as pop, i as ensure_array_like, e as escape_html, j as attr, k as stringify, b as push } from "../../../../chunks/hooks.server.js";
import "clsx";
import { o as onDestroy } from "../../../../chunks/index2.js";
import { F as Fa } from "../../../../chunks/fa.js";
/* empty css                                                              */
import { faArrowLeft, faGamepad, faClock, faStairs, faGear, faRotateRight } from "@fortawesome/free-solid-svg-icons";
/* empty css                                                                 */
import { f as feedbackStore, G as GameFeedbackModal } from "../../../../chunks/GameFeedbackModal.js";
import "canvas-confetti";
import "../../../../chunks/score.js";
import { B as Button } from "../../../../chunks/button.js";
function _page($$payload, $$props) {
  push();
  var $$store_subs;
  let difficulty = 3;
  let moves = 0;
  let timer = 0;
  let showFeedback = false;
  let currentRound = store_get($$store_subs ??= {}, "$feedbackStore", feedbackStore).currentRound;
  let shouldShowFeedback = false;
  if (store_get($$store_subs ??= {}, "$feedbackStore", feedbackStore).currentRound % 2 === 1 && !feedbackStore.isFeedbackShown(store_get($$store_subs ??= {}, "$feedbackStore", feedbackStore).currentRound)) {
    console.log("📝 Setting up initial feedback for round", store_get($$store_subs ??= {}, "$feedbackStore", feedbackStore).currentRound);
    shouldShowFeedback = true;
    setTimeout(
      () => {
        console.log("📝 Showing initial feedback for round", store_get($$store_subs ??= {}, "$feedbackStore", feedbackStore).currentRound);
        handleGamePause();
        showFeedback = true;
      },
      2e3
    );
  }
  function handleGamePause() {
    console.log("⏸️ Game paused");
  }
  const carImages = [
    "/images/games/puzzle/puzzle1.jpg",
    "/images/games/puzzle/puzzle2.jpg",
    "/images/games/puzzle/puzzle3.jpg",
    "/images/games/puzzle/puzzle4.jpg",
    "/images/games/puzzle/puzzle5.jpg",
    "/images/games/puzzle/puzzle6.jpg",
    "/images/games/puzzle/puzzle7.jpg",
    "/images/games/puzzle/puzzle8.jpg"
  ];
  let selectedImage = null;
  onDestroy(() => {
  });
  if (store_get($$store_subs ??= {}, "$feedbackStore", feedbackStore).currentRound !== currentRound) {
    currentRound = store_get($$store_subs ??= {}, "$feedbackStore", feedbackStore).currentRound;
    console.log("🔄 Round updated from store:", currentRound);
    if (shouldShowFeedback && currentRound % 2 === 1 && !feedbackStore.isFeedbackShown(currentRound)) {
      console.log("📝 Setting up feedback for new round", currentRound);
      setTimeout(
        () => {
          console.log("📝 Showing feedback for round", currentRound);
          handleGamePause();
          showFeedback = true;
        },
        2e3
      );
    }
  }
  let $$settled = true;
  let $$inner_payload;
  function $$render_inner($$payload2) {
    const each_array = ensure_array_like(carImages);
    $$payload2.out += `<div class="h-full flex flex-col"><header class="flex justify-between items-center h-14 px-6 mb-4 bg-gradient-to-r bg-orange-600/10 backdrop-blur-sm border-b border-orange-500/20 rounded-lg"><div class="flex items-center gap-6"><a href="/" class="flex items-center justify-center w-8 h-8 rounded-full hover:bg-orange-500/20 transition-colors">`;
    Fa($$payload2, { icon: faArrowLeft, class: "text-lg" });
    $$payload2.out += `<!----></a> <h1 class="text-xl font-bold tracking-tight">Piece the Puzzle</h1></div> <div class="flex items-center gap-6"><div class="flex items-center gap-2 bg-orange-500/10 px-4 py-2 rounded-lg">`;
    Fa($$payload2, { icon: faGamepad, class: "text-orange-400" });
    $$payload2.out += `<!----> <span class="font-medium">${escape_html(moves)} lëvizje</span></div> <div class="flex items-center gap-2 bg-orange-500/10 px-4 py-2 rounded-lg">`;
    Fa($$payload2, { icon: faClock, class: "text-orange-400" });
    $$payload2.out += `<!----> <span class="font-medium">${escape_html(Math.floor(timer / 60))}:${escape_html((timer % 60).toString().padStart(2, "0"))}</span></div> <div class="flex items-center gap-2 bg-orange-500/10 px-4 py-2 rounded-lg">`;
    Fa($$payload2, { icon: faStairs, class: "text-orange-400" });
    $$payload2.out += `<!----> <span class="font-medium">${escape_html(difficulty)}x${escape_html(difficulty)}</span></div> <div class="w-px h-8 bg-orange-500/20"></div> `;
    Button($$payload2, {
      variant: "ghost",
      size: "icon",
      class: "w-8 h-8 rounded-full hover:bg-orange-500/20",
      children: ($$payload3) => {
        Fa($$payload3, { icon: faGear });
      },
      $$slots: { default: true }
    });
    $$payload2.out += `<!----> `;
    Button($$payload2, {
      variant: "ghost",
      size: "icon",
      class: "w-8 h-8 rounded-full hover:bg-orange-500/20",
      children: ($$payload3) => {
        Fa($$payload3, { icon: faRotateRight });
      },
      $$slots: { default: true }
    });
    $$payload2.out += `<!----></div></header> <div class="flex-1 flex flex-col items-center gap-6 p-4"><div class="flex gap-4 overflow-x-auto p-2 max-w-full"><!--[-->`;
    for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
      let image = each_array[$$index];
      $$payload2.out += `<button${attr("class", `relative w-16 h-16 rounded-lg overflow-hidden border-2 transition-colors hover:border-orange-500 image-select ${stringify(selectedImage === image ? "selected border-orange-500" : "border-transparent")} svelte-1rtqst7`)}><img${attr("src", image)} alt="Car option" class="w-full h-full object-cover"></button>`;
    }
    $$payload2.out += `<!--]--></div> `;
    {
      $$payload2.out += "<!--[!-->";
      {
        $$payload2.out += "<!--[!-->";
      }
      $$payload2.out += `<!--]-->`;
    }
    $$payload2.out += `<!--]--></div></div> `;
    {
      $$payload2.out += "<!--[!-->";
    }
    $$payload2.out += `<!--]--> `;
    {
      $$payload2.out += "<!--[!-->";
    }
    $$payload2.out += `<!--]--> `;
    {
      $$payload2.out += "<!--[!-->";
    }
    $$payload2.out += `<!--]--> `;
    if (showFeedback) {
      $$payload2.out += "<!--[-->";
      GameFeedbackModal($$payload2);
    } else {
      $$payload2.out += "<!--[!-->";
    }
    $$payload2.out += `<!--]-->`;
  }
  do {
    $$settled = true;
    $$inner_payload = copy_payload($$payload);
    $$render_inner($$inner_payload);
  } while (!$$settled);
  assign_payload($$payload, $$inner_payload);
  if ($$store_subs) unsubscribe_stores($$store_subs);
  pop();
}
export {
  _page as default
};
