import { l as store_get, e as escape_html, u as unsubscribe_stores, p as pop, b as push } from "../../../../chunks/hooks.server.js";
import { o as onDestroy } from "../../../../chunks/index2.js";
import { F as Fa } from "../../../../chunks/fa.js";
/* empty css                                                              */
import { faArrowLeft, faClock, faRoad } from "@fortawesome/free-solid-svg-icons";
import { w as writable } from "../../../../chunks/index3.js";
import { n as noop } from "../../../../chunks/utils.js";
import { l as linear, B as Button, a as cubicOut } from "../../../../chunks/button.js";
import { t as theme } from "../../../../chunks/theme.js";
import "canvas-confetti";
/* empty css                                                                 */
import "clsx";
const now = () => Date.now();
const raf = {
  // don't access requestAnimationFrame eagerly outside method
  // this allows basic testing of user code without JSDOM
  // bunder will eval and remove ternary when the user's app is built
  tick: (
    /** @param {any} _ */
    (_) => noop()
  ),
  now: () => now(),
  tasks: /* @__PURE__ */ new Set()
};
function loop(callback) {
  let task;
  if (raf.tasks.size === 0) ;
  return {
    promise: new Promise((fulfill) => {
      raf.tasks.add(task = { c: callback, f: fulfill });
    }),
    abort() {
      raf.tasks.delete(task);
    }
  };
}
function is_date(obj) {
  return Object.prototype.toString.call(obj) === "[object Date]";
}
function get_interpolator(a, b) {
  if (a === b || a !== a) return () => a;
  const type = typeof a;
  if (type !== typeof b || Array.isArray(a) !== Array.isArray(b)) {
    throw new Error("Cannot interpolate values of different type");
  }
  if (Array.isArray(a)) {
    const arr = (
      /** @type {Array<any>} */
      b.map((bi, i) => {
        return get_interpolator(
          /** @type {Array<any>} */
          a[i],
          bi
        );
      })
    );
    return (t) => arr.map((fn) => fn(t));
  }
  if (type === "object") {
    if (!a || !b) {
      throw new Error("Object cannot be null");
    }
    if (is_date(a) && is_date(b)) {
      const an = a.getTime();
      const bn = b.getTime();
      const delta = bn - an;
      return (t) => new Date(an + t * delta);
    }
    const keys = Object.keys(b);
    const interpolators = {};
    keys.forEach((key) => {
      interpolators[key] = get_interpolator(a[key], b[key]);
    });
    return (t) => {
      const result = {};
      keys.forEach((key) => {
        result[key] = interpolators[key](t);
      });
      return result;
    };
  }
  if (type === "number") {
    const delta = (
      /** @type {number} */
      b - /** @type {number} */
      a
    );
    return (t) => a + t * delta;
  }
  throw new Error(`Cannot interpolate ${type} values`);
}
function tweened(value, defaults = {}) {
  const store = writable(value);
  let task;
  let target_value = value;
  function set(new_value, opts) {
    target_value = new_value;
    if (value == null) {
      store.set(value = new_value);
      return Promise.resolve();
    }
    let previous_task = task;
    let started = false;
    let {
      delay = 0,
      duration = 400,
      easing = linear,
      interpolate = get_interpolator
    } = { ...defaults, ...opts };
    if (duration === 0) {
      if (previous_task) {
        previous_task.abort();
        previous_task = null;
      }
      store.set(value = target_value);
      return Promise.resolve();
    }
    const start = raf.now() + delay;
    let fn;
    task = loop((now2) => {
      if (now2 < start) return true;
      if (!started) {
        fn = interpolate(
          /** @type {any} */
          value,
          new_value
        );
        if (typeof duration === "function")
          duration = duration(
            /** @type {any} */
            value,
            new_value
          );
        started = true;
      }
      if (previous_task) {
        previous_task.abort();
        previous_task = null;
      }
      const elapsed = now2 - start;
      if (elapsed > /** @type {number} */
      duration) {
        store.set(value = new_value);
        return false;
      }
      store.set(value = fn(easing(elapsed / duration)));
      return true;
    });
    return task.promise;
  }
  return {
    set,
    update: (fn, opts) => set(fn(
      /** @type {any} */
      target_value,
      /** @type {any} */
      value
    ), opts),
    subscribe: store.subscribe
  };
}
function _page($$payload, $$props) {
  push();
  var $$store_subs;
  let distance = 0;
  let timer = 0;
  tweened(0, { duration: 150, easing: cubicOut });
  const THEME_COLORS = {
    light: {
      road: "#404040",
      roadLine: "#ffffff",
      roadShoulder: "#505050",
      header: "#f0f0f0",
      gradientTop: "#90EE99",
      // Light orange
      gradientBottom: "#90EE90",
      // Light green
      speedLines: "rgba(255, 255, 255, 0.8)",
      particleBase: "180, 180, 180",
      overlay: "rgba(255, 179, 71, 0.1)"
      // Light orange overlay
    },
    dark: {
      road: "#1a1a1a",
      roadLine: "#ffffff",
      roadShoulder: "#2a2a2a",
      header: "#0f172a",
      gradientTop: "#1a2456",
      // Dark blue
      gradientBottom: "#2a3466",
      // Slightly lighter blue
      speedLines: "rgba(255, 255, 255, 0.15)",
      particleBase: "80, 80, 80",
      overlay: "rgba(26, 36, 86, 0.3)"
      // Dark blue overlay
    }
  };
  onDestroy(() => {
    window.removeEventListener("keydown", handleKeydown);
  });
  function handleKeydown(e) {
    return;
  }
  store_get($$store_subs ??= {}, "$theme", theme) === "light" ? THEME_COLORS.light : THEME_COLORS.dark;
  $$payload.out += `<div class="h-full flex flex-col"><header class="flex justify-between items-center h-14 px-6 mb-4 text-white dark:text-white bg-gradient-to-r bg-orange-600/20 backdrop-blur-lg border-b border-orange-500/30 rounded-lg z-20"><div class="flex items-center gap-6"><a href="/" class="flex items-center justify-center w-8 h-8 rounded-full hover:bg-orange-600 transition-colors">`;
  Fa($$payload, { icon: faArrowLeft, class: "text-lg" });
  $$payload.out += `<!----></a> <h1 class="text-lg font-semibold">Race the Road</h1></div> <div class="flex items-center gap-4"><div class="flex items-center gap-2 bg-orange-500/10 px-4 py-2 rounded-lg">`;
  Fa($$payload, { icon: faClock, class: "text-orange-400" });
  $$payload.out += `<!----> <span>${escape_html(Math.floor(timer / 60))}:${escape_html((timer % 60).toString().padStart(2, "0"))}</span></div> <div class="flex items-center gap-2 bg-orange-500/10 px-4 py-2 rounded-lg">`;
  Fa($$payload, { icon: faRoad, class: "text-orange-400" });
  $$payload.out += `<!----> <span>${escape_html(Math.floor(distance))}m</span></div></div></header> <div class="absolute top-0 left-[50%] translate-x-[-50%] h-full"><div class="relative aspect-[16/9] h-full borderorder-slate-700 rounded-lg overflow-hidden bg-slate-900"><canvas id="gameCanvas" class="absolute inset-0 w-full h-full svelte-dlpd3u"></canvas> `;
  {
    $$payload.out += "<!--[-->";
    $$payload.out += `<div class="absolute inset-0 flex items-center justify-center bg-black/50 text-white"><div class="text-center"><h3 class="text-3xl font-bold mb-4">Race the Road</h3> <p class="mb-4 text-slate-300">Shpejto përmes trafikut dhe shiko sa larg mund të arrish.<br></p> `;
    Button($$payload, {
      class: "bg-orange-500 text-white hover:bg-orange-600",
      children: ($$payload2) => {
        $$payload2.out += `<!---->Nis lojën`;
      },
      $$slots: { default: true }
    });
    $$payload.out += `<!----></div></div>`;
  }
  $$payload.out += `<!--]--> `;
  {
    $$payload.out += "<!--[!-->";
  }
  $$payload.out += `<!--]--> `;
  {
    $$payload.out += "<!--[!-->";
  }
  $$payload.out += `<!--]--> `;
  {
    $$payload.out += "<!--[!-->";
  }
  $$payload.out += `<!--]--></div></div></div>`;
  if ($$store_subs) unsubscribe_stores($$store_subs);
  pop();
}
export {
  _page as default
};
