/// <reference types="svelte" />
import type { CreateDatePickerProps } from './types.js';
import type { MeltActionReturn } from '../../internal/types.js';
import type { DatePickerEvents } from './events.js';
export declare function createDatePicker(props?: CreateDatePickerProps): {
    elements: {
        trigger: import("../../internal/helpers/index.js").MeltElement<[import("../../internal/helpers/index.js").MeltElement<[import("svelte/store").Readable<boolean>, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<string>>, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<string>>], (node: HTMLElement) => MeltActionReturn<"click" | "keydown">, ([$isVisible, $contentId, $triggerId]: [boolean, string, string]) => {
            readonly role: "button";
            readonly 'aria-haspopup': "dialog";
            readonly 'aria-expanded': "true" | "false";
            readonly 'data-state': "open" | "closed";
            readonly 'aria-controls': string;
            readonly id: string;
        }, string>, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<boolean>>], (node: HTMLElement) => MeltActionReturn<DatePickerEvents['trigger']>, ([$trigger, $disabled]: [{
            readonly role: "button";
            readonly 'aria-haspopup': "dialog";
            readonly 'aria-expanded': "true" | "false";
            readonly 'data-state': "open" | "closed";
            readonly 'aria-controls': string;
            readonly id: string;
        } & {
            [x: `data-melt-${string}`]: "";
        } & {
            action: (node: HTMLElement) => MeltActionReturn<"click" | "keydown">;
        }, boolean]) => {
            'aria-label': string;
            'data-segment': string;
            disabled: boolean | undefined;
            'data-state': "open" | "closed";
            'aria-expanded': "true" | "false";
            'aria-controls': string;
            role: "button";
            id: string;
            'aria-haspopup': "dialog";
        }, "popover-trigger">;
        content: import("../../internal/helpers/index.js").MeltElement<[import("svelte/store").Readable<boolean>, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<string | HTMLElement | null | undefined>>, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<string>>], <Node_1 extends any>(node: HTMLElement) => {
            destroy(): void;
        }, ([$isVisible, $portal, $contentId]: [boolean, string | HTMLElement | null | undefined, string]) => {
            hidden: boolean | undefined;
            tabindex: number;
            style: string;
            id: string;
            'data-state': string;
            'data-portal': string | undefined;
        }, string>;
        arrow: import("../../internal/helpers/index.js").MeltElement<import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<number>>, import("svelte/action").Action<any, any, Record<never, any>>, ($arrowSize: number) => {
            'data-arrow': boolean;
            style: string;
        }, string>;
        close: import("../../internal/helpers/index.js").MeltElement<import("svelte/store").Stores | undefined, (node: HTMLElement) => MeltActionReturn<"click" | "keydown">, () => {
            readonly type: "button";
        }, string>;
        overlay: import("../../internal/helpers/index.js").MeltElement<[import("svelte/store").Readable<boolean>], <Node_2 extends any>(node: HTMLElement) => {
            destroy(): void;
        }, ([$isVisible]: [boolean]) => {
            readonly hidden: true | undefined;
            readonly tabindex: -1;
            readonly style: string;
            readonly 'aria-hidden': "true";
            readonly 'data-state': "open" | "closed";
        }, string>;
        field: import("../../internal/helpers/index.js").MeltElement<[{
            update: (updater: import("svelte/store").Updater<import("@internationalized/date").DateValue | undefined>, sideEffect?: ((newValue: import("@internationalized/date").DateValue | undefined) => void) | undefined) => void;
            set: (this: void, value: import("@internationalized/date").DateValue | undefined) => void;
            subscribe(this: void, run: import("svelte/store").Subscriber<import("@internationalized/date").DateValue | undefined>, invalidate?: import("svelte/store").Invalidator<import("@internationalized/date").DateValue | undefined> | undefined): import("svelte/store").Unsubscriber;
            get: () => import("@internationalized/date").DateValue | undefined;
            destroy?: (() => void) | undefined;
        }, import("svelte/store").Readable<boolean>, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<boolean>>, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<boolean>>, import("svelte/store").Readable<{
            field: string;
            label: string;
            description: string;
            validation: string;
        }>], <Node_3 extends any>(_node: HTMLElement) => {
            destroy(): void;
        }, ([$value, $isInvalid, $disabled, $readonly, $ids]: [import("@internationalized/date").DateValue | undefined, boolean, boolean, boolean, {
            field: string;
            label: string;
            description: string;
            validation: string;
        }]) => {
            role: string;
            id: string;
            'aria-labelledby': string;
            'aria-describedby': string;
            'aria-disabled': "true" | undefined;
            'aria-readonly': "true" | undefined;
            'data-invalid': string | undefined;
            'data-disabled': string | undefined;
        }, string>;
        segment: import("../../internal/helpers/index.js").MeltElement<[import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<import("../date-field/_internal/types.js").SegmentValueObj>>, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<12 | 24 | undefined>>, {
            get: () => import("@internationalized/date").DateValue;
            set: (this: void, value: import("@internationalized/date").DateValue) => void;
            update: (this: void, updater: import("svelte/store").Updater<import("@internationalized/date").DateValue>) => void;
            subscribe: (this: void, run: import("svelte/store").Subscriber<import("@internationalized/date").DateValue>, invalidate?: import("svelte/store").Invalidator<import("@internationalized/date").DateValue> | undefined) => import("svelte/store").Unsubscriber;
            add: (duration: import("@internationalized/date").DateTimeDuration | import("@internationalized/date").DateDuration) => void;
            subtract: (duration: import("@internationalized/date").DateTimeDuration | import("@internationalized/date").DateDuration) => void;
            setDate: (fields: import("@internationalized/date").DateFields | (import("@internationalized/date").DateFields & import("@internationalized/date").TimeFields), disambiguation?: import("@internationalized/date").Disambiguation | undefined) => void;
            reset: () => void;
            toWritable: () => {
                set: (this: void, value: import("@internationalized/date").DateValue) => void;
                subscribe: (this: void, run: import("svelte/store").Subscriber<import("@internationalized/date").DateValue>, invalidate?: import("svelte/store").Invalidator<import("@internationalized/date").DateValue> | undefined) => import("svelte/store").Unsubscriber;
                update: (this: void, updater: import("svelte/store").Updater<import("@internationalized/date").DateValue>) => void;
                get: () => import("@internationalized/date").DateValue;
            };
            nextPage: (amount: number) => void;
            prevPage: (amount: number) => void;
        }, {
            update: (updater: import("svelte/store").Updater<import("@internationalized/date").DateValue | undefined>, sideEffect?: ((newValue: import("@internationalized/date").DateValue | undefined) => void) | undefined) => void;
            set: (this: void, value: import("@internationalized/date").DateValue | undefined) => void;
            subscribe(this: void, run: import("svelte/store").Subscriber<import("@internationalized/date").DateValue | undefined>, invalidate?: import("svelte/store").Invalidator<import("@internationalized/date").DateValue | undefined> | undefined): import("svelte/store").Unsubscriber;
            get: () => import("@internationalized/date").DateValue | undefined;
            destroy?: (() => void) | undefined;
        }, import("svelte/store").Readable<boolean>, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<boolean>>, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<boolean>>, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Readable<Set<import("../../index.js").SegmentPart>>>, import("svelte/store").Readable<{
            field: string;
            label: string;
            description: string;
            validation: string;
            day: string;
            month: string;
            year: string;
            hour: string;
            minute: string;
            second: string;
            dayPeriod: string;
            timeZoneName: string;
        }>, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<string>>], (node: HTMLElement) => MeltActionReturn<"click" | "focusout" | "keydown">, ([$segmentValues, $hourCycle, $placeholder, $value, $isInvalid, $disabled, $readonly, $readonlySegmentsSet, $idValues, _,]: [import("../date-field/_internal/types.js").SegmentValueObj, 12 | 24 | undefined, import("@internationalized/date").DateValue, import("@internationalized/date").DateValue | undefined, boolean, boolean, boolean, Set<import("../../index.js").SegmentPart>, {
            field: string;
            label: string;
            description: string;
            validation: string;
            day: string;
            month: string;
            year: string;
            hour: string;
            minute: string;
            second: string;
            dayPeriod: string;
            timeZoneName: string;
        }, string]) => (part: import("../../index.js").SegmentPart) => {
            'aria-invalid': "true" | undefined;
            'aria-disabled': "true" | undefined;
            'aria-readonly': "true" | undefined;
            'data-invalid': string | undefined;
            'data-disabled': string | undefined;
            'data-segment': string;
        } | {
            id: string;
            'aria-labelledby': string;
            contenteditable: boolean;
            'aria-describedby': string | undefined;
            tabindex: number | undefined;
            'aria-invalid': "true" | undefined;
            'aria-disabled': "true" | undefined;
            'aria-readonly': "true" | undefined;
            'data-invalid': string | undefined;
            'data-disabled': string | undefined;
            'data-segment': string;
        }, string>;
        label: import("../../internal/helpers/index.js").MeltElement<[import("svelte/store").Readable<boolean>, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<boolean>>, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<string>>], (node: HTMLElement) => {
            destroy: () => void;
        }, ([$isInvalid, $disabled, $labelId]: [boolean, boolean, string]) => {
            id: string;
            'data-invalid': string | undefined;
            'data-disabled': string | undefined;
        }, string>;
        hiddenInput: import("../../internal/helpers/index.js").MeltElement<[import("../../internal/helpers/index.js").WithGet<import("svelte/store").Readable<string>>, import("svelte/motion").Readable<string | undefined>, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Readable<boolean>>, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Readable<boolean>>], (node: HTMLInputElement) => {
            destroy: import("svelte/store").Unsubscriber;
        }, ([$value, $name, $disabled, $required]: [string, string | undefined, boolean, boolean]) => {
            name: string | undefined;
            value: string;
            'aria-hidden': "true";
            hidden: boolean;
            disabled: boolean;
            required: boolean;
            tabIndex: number;
            style: string;
        }, string>;
        validation: import("../../internal/helpers/index.js").MeltElement<[import("svelte/store").Readable<boolean>, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<string>>], import("svelte/action").Action<any, any, Record<never, any>>, ([$isInvalid, $validationId]: [boolean, string]) => {
            id: string;
            'data-invalid': string | undefined;
            style: string | undefined;
        }, string>;
        calendar: import("../../internal/helpers/index.js").MeltElement<[import("../../internal/helpers/index.js").WithGet<import("svelte/store").Readable<string>>, import("svelte/store").Readable<boolean>, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<boolean>>, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<boolean>>, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<string>>], (node: HTMLElement) => MeltActionReturn<"keydown">, ([$fullCalendarLabel, $isInvalid, $disabled, $readonly, $calendarId]: [string, boolean, boolean, boolean, string]) => {
            id: string;
            role: string;
            'aria-label': string;
            'data-invalid': string | undefined;
            'data-disabled': string | undefined;
            'data-readonly': string | undefined;
        }, string>;
        heading: import("../../internal/helpers/index.js").MeltElement<[import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<boolean>>], import("svelte/action").Action<any, any, Record<never, any>>, ([$disabled]: [boolean]) => {
            'aria-hidden': boolean;
            'data-disabled': string | undefined;
        }, string>;
        grid: import("../../internal/helpers/index.js").MeltElement<[import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<boolean>>, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<boolean>>], import("svelte/action").Action<any, any, Record<never, any>>, ([$readonly, $disabled]: [boolean, boolean]) => {
            tabindex: number;
            role: string;
            'aria-readonly': "true" | undefined;
            'aria-disabled': "true" | undefined;
            'data-readonly': string | undefined;
            'data-disabled': string | undefined;
        }, string>;
        cell: import("../../internal/helpers/index.js").MeltElement<[import("svelte/store").Readable<(date: import("@internationalized/date").DateValue) => boolean>, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Readable<(date: import("@internationalized/date").DateValue) => boolean>>, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<import("../../internal/helpers/date/index.js").Matcher | undefined>>, import("svelte/store").Readable<(date: import("@internationalized/date").DateValue) => boolean>, {
            get: () => import("@internationalized/date").DateValue;
            set: (this: void, value: import("@internationalized/date").DateValue) => void;
            update: (this: void, updater: import("svelte/store").Updater<import("@internationalized/date").DateValue>) => void;
            subscribe: (this: void, run: import("svelte/store").Subscriber<import("@internationalized/date").DateValue>, invalidate?: import("svelte/store").Invalidator<import("@internationalized/date").DateValue> | undefined) => import("svelte/store").Unsubscriber;
            add: (duration: import("@internationalized/date").DateTimeDuration | import("@internationalized/date").DateDuration) => void;
            subtract: (duration: import("@internationalized/date").DateTimeDuration | import("@internationalized/date").DateDuration) => void;
            setDate: (fields: import("@internationalized/date").DateFields | (import("@internationalized/date").DateFields & import("@internationalized/date").TimeFields), disambiguation?: import("@internationalized/date").Disambiguation | undefined) => void;
            reset: () => void;
            toWritable: () => {
                set: (this: void, value: import("@internationalized/date").DateValue) => void;
                subscribe: (this: void, run: import("svelte/store").Subscriber<import("@internationalized/date").DateValue>, invalidate?: import("svelte/store").Invalidator<import("@internationalized/date").DateValue> | undefined) => import("svelte/store").Unsubscriber;
                update: (this: void, updater: import("svelte/store").Updater<import("@internationalized/date").DateValue>) => void;
                get: () => import("@internationalized/date").DateValue;
            };
            nextPage: (amount: number) => void;
            prevPage: (amount: number) => void;
        }], (node: HTMLElement) => MeltActionReturn<"click">, ([$isDateSelected, $isDateDisabled, $isDateUnavailable, $isOutsideVisibleMonths, $placeholder,]: [(date: import("@internationalized/date").DateValue) => boolean, (date: import("@internationalized/date").DateValue) => boolean, import("../../internal/helpers/date/index.js").Matcher | undefined, (date: import("@internationalized/date").DateValue) => boolean, import("@internationalized/date").DateValue]) => (cellValue: import("@internationalized/date").DateValue, monthValue: import("@internationalized/date").DateValue) => {
            readonly role: "button";
            readonly 'aria-label': string;
            readonly 'aria-selected': true | undefined;
            readonly 'aria-disabled': true | undefined;
            readonly 'data-selected': true | undefined;
            readonly 'data-value': string;
            readonly 'data-disabled': "" | undefined;
            readonly 'data-unavailable': "" | undefined;
            readonly 'data-today': "" | undefined;
            readonly 'data-outside-month': "" | undefined;
            readonly 'data-outside-visible-months': "" | undefined;
            readonly 'data-focused': "" | undefined;
            readonly tabindex: 0 | -1 | undefined;
        }, string>;
        nextButton: import("../../internal/helpers/index.js").MeltElement<[import("../../internal/helpers/index.js").WithGet<import("svelte/store").Readable<boolean>>], (node: HTMLElement) => MeltActionReturn<"click">, ([$isNextButtonDisabled]: [boolean]) => {
            role: string;
            type: "button";
            'aria-label': string;
            'aria-disabled': "true" | undefined;
            'data-disabled': string | undefined;
            disabled: boolean | undefined;
        }, string>;
        prevButton: import("../../internal/helpers/index.js").MeltElement<[import("../../internal/helpers/index.js").WithGet<import("svelte/store").Readable<boolean>>], (node: HTMLElement) => MeltActionReturn<"click">, ([$isPrevButtonDisabled]: [boolean]) => {
            role: string;
            type: "button";
            'aria-label': string;
            'aria-disabled': "true" | undefined;
            'data-disabled': string | undefined;
            disabled: boolean | undefined;
        }, string>;
    };
    states: {
        open: {
            update: (updater: import("svelte/store").Updater<boolean>, sideEffect?: ((newValue: boolean) => void) | undefined) => void;
            set: (this: void, value: boolean) => void;
            subscribe(this: void, run: import("svelte/store").Subscriber<boolean>, invalidate?: import("svelte/store").Invalidator<boolean> | undefined): import("svelte/store").Unsubscriber;
            get: () => boolean;
            destroy?: (() => void) | undefined;
        };
        placeholder: {
            set: (this: void, value: import("@internationalized/date").DateValue) => void;
            subscribe: (this: void, run: import("svelte/store").Subscriber<import("@internationalized/date").DateValue>, invalidate?: import("svelte/store").Invalidator<import("@internationalized/date").DateValue> | undefined) => import("svelte/store").Unsubscriber;
            update: (this: void, updater: import("svelte/store").Updater<import("@internationalized/date").DateValue>) => void;
            get: () => import("@internationalized/date").DateValue;
        };
        value: {
            update: (updater: import("svelte/store").Updater<import("@internationalized/date").DateValue | undefined>, sideEffect?: ((newValue: import("@internationalized/date").DateValue | undefined) => void) | undefined) => void;
            set: (this: void, value: import("@internationalized/date").DateValue | undefined) => void;
            subscribe(this: void, run: import("svelte/store").Subscriber<import("@internationalized/date").DateValue | undefined>, invalidate?: import("svelte/store").Invalidator<import("@internationalized/date").DateValue | undefined> | undefined): import("svelte/store").Unsubscriber;
            get: () => import("@internationalized/date").DateValue | undefined;
            destroy?: (() => void) | undefined;
        };
        months: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<import("../../internal/helpers/date/index.js").Month<import("@internationalized/date").DateValue>[]>>;
        weekdays: import("svelte/store").Readable<string[]>;
        headingValue: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Readable<string>>;
        segmentValues: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<import("../date-field/_internal/types.js").SegmentValueObj>>;
        segmentContents: import("svelte/store").Readable<{
            part: import("../../index.js").SegmentPart;
            value: string;
        }[]>;
        segmentContentsObj: import("svelte/store").Readable<import("../date-field/_internal/types.js").SegmentContentObj>;
        isInvalid: import("svelte/store").Readable<boolean>;
    };
    helpers: {
        nextPage: () => void;
        prevPage: () => void;
        nextYear: () => void;
        prevYear: () => void;
        setYear: (year: number) => void;
        setMonth: (month: number) => void;
        isDateDisabled: import("svelte/store").Readable<(date: import("@internationalized/date").DateValue) => boolean>;
        isDateSelected: import("svelte/store").Readable<(date: import("@internationalized/date").DateValue) => boolean>;
        isDateUnavailable: import("svelte/store").Readable<(date: import("@internationalized/date").DateValue) => boolean | undefined>;
    };
    options: {
        forceVisible: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<boolean>>;
        preventScroll: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<boolean>>;
        portal: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<string | HTMLElement | null | undefined>>;
        defaultOpen: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<boolean>>;
        onOpenChange: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<import("../../internal/helpers/index.js").ChangeFn<boolean> | undefined>>;
        positioning: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<import("../../internal/actions/index.js").FloatingConfig | {
            placement: "bottom";
        }>>;
        arrowSize: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<number>>;
        closeOnOutsideClick: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<boolean>>;
        closeOnEscape: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<boolean>>;
        onOutsideClick: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<((event: import("../../index.js").InteractOutsideEvent) => void) | undefined>>;
        closeFocus: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<import("../../internal/helpers/index.js").FocusProp | undefined>>;
        disableFocusTrap: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<boolean>>;
        openFocus: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<import("../../internal/helpers/index.js").FocusProp | undefined>>;
        disabled: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<boolean>>;
        open?: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<import("svelte/store").Writable<boolean> | undefined>> | undefined;
        name: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<string | undefined>>;
        onValueChange?: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<import("../../internal/helpers/index.js").ChangeFn<import("@internationalized/date").DateValue | undefined> | undefined>> | undefined;
        defaultValue?: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<import("@internationalized/date").DateValue | undefined>> | undefined;
        multiple: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<false | undefined>>;
        required: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<boolean | undefined>>;
        defaultPlaceholder?: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<import("@internationalized/date").DateValue | undefined>> | undefined;
        granularity: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<import("../../internal/helpers/date/index.js").Granularity | undefined>>;
        onPlaceholderChange?: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<import("../../internal/helpers/index.js").ChangeFn<import("@internationalized/date").DateValue> | undefined>> | undefined;
        isDateUnavailable: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<import("../../internal/helpers/date/index.js").Matcher | undefined>>;
        minValue: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<import("@internationalized/date").DateValue | undefined>>;
        maxValue: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<import("@internationalized/date").DateValue | undefined>>;
        readonly: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<boolean>>;
        hourCycle: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<12 | 24 | undefined>>;
        locale: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<string>>;
        hideTimeZone: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<boolean | undefined>>;
        weekStartsOn: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<0 | 1 | 2 | 3 | 4 | 5 | 6>>;
        fixedWeeks: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<boolean>>;
        numberOfMonths: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<number>>;
        preventDeselect: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<boolean>>;
        pagedNavigation: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<boolean>>;
        weekdayFormat: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<"long" | "short" | "narrow">>;
        isDateDisabled: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<import("../../internal/helpers/date/index.js").Matcher | undefined>>;
        calendarLabel: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<string>>;
        dateFieldIds?: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<Partial<{
            label: string;
            description: string;
            day: string;
            hour: string;
            minute: string;
            second: string;
            month: string;
            year: string;
            dayPeriod: string;
            timeZoneName: string;
            field: string;
            validation: string;
        }> | undefined>> | undefined;
        calendarIds?: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<Partial<{
            calendar: string;
            accessibleHeading: string;
        }> | undefined>> | undefined;
        popoverIds?: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<Partial<{
            content: string;
            trigger: string;
        }> | undefined>> | undefined;
        readonlySegments: import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<("day" | "hour" | "minute" | "second" | "month" | "year" | "dayPeriod")[] | undefined>>;
    };
    ids: {
        dateField: import("../../internal/helpers/index.js").ToWritableStores<{
            label: string;
            description: string;
            day: string;
            hour: string;
            minute: string;
            second: string;
            month: string;
            year: string;
            dayPeriod: string;
            timeZoneName: string;
            field: string;
            validation: string;
        }>;
        calendar: import("../../internal/helpers/index.js").ToWritableStores<{
            calendar: string;
            accessibleHeading: string;
        }>;
        popover: import("../../internal/helpers/index.js").ToWritableStores<{
            content: string;
            trigger: string;
        }>;
    };
};
